/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.tenantcontrol;

import com.hazelcast.spi.impl.tenantcontrol.NoopTenantControl;
import com.hazelcast.spi.tenantcontrol.TenantControl;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class TenantContextual<T> {
    private static final TenantContextual<?> NOOP = new TenantContextual<Object>(() -> null, () -> false, new NoopTenantControl());
    private T contextual;
    private volatile boolean initialized;
    private final Supplier<T> initFunction;
    private final Supplier<Boolean> existsFunction;
    private final TenantControl tenantControl;
    private final Lock lock = new ReentrantLock();

    private TenantContextual(Supplier<T> initFunction, Supplier<Boolean> existsFunction, TenantControl tenantControl) {
        this.initFunction = initFunction;
        this.existsFunction = existsFunction;
        this.tenantControl = tenantControl;
    }

    public static <T> TenantContextual<T> create(Supplier<T> initFunction, Supplier<Boolean> existsFunction, TenantControl tenantControl) {
        if (tenantControl == TenantControl.NOOP_TENANT_CONTROL && !existsFunction.get().booleanValue()) {
            return NOOP;
        }
        return new TenantContextual<T>(initFunction, existsFunction, tenantControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        block17: {
            if (!this.initialized) {
                this.lock.lock();
                try {
                    if (this.initialized) break block17;
                    if (this.exists().booleanValue()) {
                        try (TenantControl.Closeable tenantContext = this.tenantControl.setTenant();){
                            this.contextual = this.initFunction.get();
                        }
                    }
                    this.initialized = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return this.contextual;
    }

    public Boolean exists() {
        return this.existsFunction.get();
    }

    public TenantControl getTenantControl() {
        return this.tenantControl;
    }

    public TenantContextual<T> delegate(T delegate) {
        if (this == NOOP) {
            return this;
        }
        TenantContextual<T> newContextual = new TenantContextual<T>(this.initFunction, this.existsFunction, this.tenantControl);
        newContextual.initialized = true;
        newContextual.contextual = delegate;
        return newContextual;
    }
}

