/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.map.LocalMapStats;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

class MapInfoCollector
implements MetricsCollector {
    private static final Predicate<MapConfig> IS_MAP_STORE_ENABLED = mapConfig -> mapConfig.getMapStoreConfig().isEnabled();
    private Collection<MapConfig> mapConfigs;

    MapInfoCollector() {
    }

    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer) {
        Collection<DistributedObject> objects = node.hazelcastInstance.getDistributedObjects();
        this.mapConfigs = objects.stream().filter(obj -> obj.getServiceName().equals("hz:impl:mapService")).map(obj -> node.getConfig().getMapConfig(obj.getName())).filter(Objects::nonNull).collect(Collectors.toList());
        metricsConsumer.accept(PhoneHomeMetrics.MAP_COUNT_WITH_READ_ENABLED, String.valueOf(this.countMapWithBackupReadEnabled()));
        metricsConsumer.accept(PhoneHomeMetrics.MAP_COUNT_WITH_MAP_STORE_ENABLED, String.valueOf(this.countMapWithMapStoreEnabled()));
        metricsConsumer.accept(PhoneHomeMetrics.MAP_COUNT_WITH_ATLEAST_ONE_QUERY_CACHE, String.valueOf(this.countMapWithAtleastOneQueryCache()));
        metricsConsumer.accept(PhoneHomeMetrics.MAP_COUNT_WITH_ATLEAST_ONE_INDEX, String.valueOf(this.countMapWithAtleastOneIndex()));
        metricsConsumer.accept(PhoneHomeMetrics.MAP_COUNT_WITH_HOT_RESTART_ENABLED, String.valueOf(this.countMapWithHotRestartEnabled()));
        metricsConsumer.accept(PhoneHomeMetrics.MAP_COUNT_WITH_WAN_REPLICATION, String.valueOf(this.countMapWithWANReplication()));
        metricsConsumer.accept(PhoneHomeMetrics.MAP_COUNT_WITH_ATLEAST_ONE_ATTRIBUTE, String.valueOf(this.countMapWithAtleastOneAttribute()));
        metricsConsumer.accept(PhoneHomeMetrics.MAP_COUNT_USING_EVICTION, String.valueOf(this.countMapUsingEviction()));
        metricsConsumer.accept(PhoneHomeMetrics.MAP_COUNT_USING_NATIVE_INMEMORY_FORMAT, String.valueOf(this.countMapWithNativeInMemoryFormat()));
        metricsConsumer.accept(PhoneHomeMetrics.AVERAGE_PUT_LATENCY_OF_MAPS_USING_MAPSTORE, String.valueOf(this.mapOperationLatency(node, IS_MAP_STORE_ENABLED, LocalMapStats::getTotalPutLatency, LocalMapStats::getPutOperationCount)));
        metricsConsumer.accept(PhoneHomeMetrics.AVERAGE_PUT_LATENCY_OF_MAPS_WITHOUT_MAPSTORE, String.valueOf(this.mapOperationLatency(node, IS_MAP_STORE_ENABLED.negate(), LocalMapStats::getTotalPutLatency, LocalMapStats::getPutOperationCount)));
        metricsConsumer.accept(PhoneHomeMetrics.AVERAGE_GET_LATENCY_OF_MAPS_USING_MAPSTORE, String.valueOf(this.mapOperationLatency(node, IS_MAP_STORE_ENABLED, LocalMapStats::getTotalGetLatency, LocalMapStats::getGetOperationCount)));
        metricsConsumer.accept(PhoneHomeMetrics.AVERAGE_GET_LATENCY_OF_MAPS_WITHOUT_MAPSTORE, String.valueOf(this.mapOperationLatency(node, IS_MAP_STORE_ENABLED.negate(), LocalMapStats::getTotalGetLatency, LocalMapStats::getGetOperationCount)));
    }

    private long countMapWithBackupReadEnabled() {
        return this.mapConfigs.stream().filter(MapConfig::isReadBackupData).count();
    }

    private long countMapWithMapStoreEnabled() {
        return this.mapConfigs.stream().map(MapConfig::getMapStoreConfig).filter(MapStoreConfig::isEnabled).count();
    }

    private long countMapWithAtleastOneQueryCache() {
        return this.mapConfigs.stream().map(MapConfig::getQueryCacheConfigs).filter(queryCacheConfigs -> !queryCacheConfigs.isEmpty()).count();
    }

    private long countMapWithAtleastOneIndex() {
        return this.mapConfigs.stream().map(MapConfig::getIndexConfigs).filter(indexConfigs -> !indexConfigs.isEmpty()).count();
    }

    private long countMapWithHotRestartEnabled() {
        return this.mapConfigs.stream().map(MapConfig::getHotRestartConfig).filter(HotRestartConfig::isEnabled).count();
    }

    private long countMapWithWANReplication() {
        return this.mapConfigs.stream().map(MapConfig::getWanReplicationRef).filter(Objects::nonNull).count();
    }

    private long countMapWithAtleastOneAttribute() {
        return this.mapConfigs.stream().map(MapConfig::getAttributeConfigs).filter(attributeConfigs -> !attributeConfigs.isEmpty()).count();
    }

    private long countMapUsingEviction() {
        return this.mapConfigs.stream().map(MapConfig::getEvictionConfig).filter(evictionConfig -> evictionConfig.getEvictionPolicy() != EvictionPolicy.NONE).count();
    }

    private long countMapWithNativeInMemoryFormat() {
        return this.mapConfigs.stream().map(MapConfig::getInMemoryFormat).filter(inMemoryFormat -> inMemoryFormat == InMemoryFormat.NATIVE).count();
    }

    private long mapOperationLatency(Node node, Predicate<MapConfig> predicate, ToLongFunction<LocalMapStats> totalLatencyProvider, ToLongFunction<LocalMapStats> operationCountProvider) {
        LatencyInfo latencyInfo = new LatencyInfo(0L, 0L);
        this.mapConfigs.stream().filter(predicate).map(mapConfig -> node.hazelcastInstance.getMap(mapConfig.getName()).getLocalMapStats()).forEach(mapStats -> latencyInfo.add(totalLatencyProvider.applyAsLong((LocalMapStats)mapStats), operationCountProvider.applyAsLong((LocalMapStats)mapStats)));
        return latencyInfo.calculateAverage();
    }

    static class LatencyInfo {
        private long totalLatency;
        private long operationCount;

        LatencyInfo(long totalLatency, long operationCount) {
            this.totalLatency = totalLatency;
            this.operationCount = operationCount;
        }

        void add(long totalLatency, long operationCount) {
            this.totalLatency += totalLatency;
            this.operationCount += operationCount;
        }

        long calculateAverage() {
            return this.operationCount == 0L ? -1L : this.totalLatency / this.operationCount;
        }
    }
}

