/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.diagnostics.OperationProfilerPlugin;
import com.hazelcast.internal.diagnostics.PendingInvocationsPlugin;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.TimeUnit;

public class InvocationProfilerPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.invocation-profiler.period.seconds", 5, TimeUnit.SECONDS);
    private final InvocationRegistry invocationRegistry;
    private final long periodMs;

    public InvocationProfilerPlugin(NodeEngineImpl nodeEngine) {
        super(nodeEngine.getLogger(PendingInvocationsPlugin.class));
        OperationServiceImpl operationService = nodeEngine.getOperationService();
        this.invocationRegistry = operationService.getInvocationRegistry();
        this.periodMs = nodeEngine.getProperties().getMillis(PERIOD_SECONDS);
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMs;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active: period-millis:" + this.periodMs);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        writer.startSection("InvocationProfiler");
        OperationProfilerPlugin.write(writer, this.invocationRegistry.latencyDistributions());
        writer.endSection();
    }
}

