/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.sql.impl.client.SqlError;
import java.util.UUID;

public final class SqlErrorCodec {
    private static final int CODE_FIELD_OFFSET = 0;
    private static final int ORIGINATING_MEMBER_ID_FIELD_OFFSET = 4;
    private static final int INITIAL_FRAME_SIZE = 21;

    private SqlErrorCodec() {
    }

    public static void encode(ClientMessage clientMessage, SqlError sqlError) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, sqlError.getCode());
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 4, sqlError.getOriginatingMemberId());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, sqlError.getMessage(), StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static SqlError decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int code = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        UUID originatingMemberId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 4);
        String message = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new SqlError(code, message, originatingMemberId);
    }
}

