/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.atomiclong;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAddAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongApplyCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndAddCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetCodec;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.AlterOp;
import com.hazelcast.spi.impl.InternalCompletableFuture;

public class AtomicLongProxy
extends ClientProxy
implements IAtomicLong {
    private final RaftGroupId groupId;
    private final String objectName;

    public AtomicLongProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:atomicLongService", proxyName, context);
        this.groupId = groupId;
        this.objectName = objectName;
    }

    @Override
    public long addAndGet(long delta) {
        return (Long)((InternalCompletableFuture)this.addAndGetAsync(delta)).joinInternal();
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        return (Boolean)((InternalCompletableFuture)this.compareAndSetAsync(expect, update)).joinInternal();
    }

    @Override
    public long decrementAndGet() {
        return (Long)((InternalCompletableFuture)this.decrementAndGetAsync()).joinInternal();
    }

    @Override
    public long getAndDecrement() {
        return (Long)((InternalCompletableFuture)this.getAndDecrementAsync()).joinInternal();
    }

    @Override
    public long get() {
        return (Long)((InternalCompletableFuture)this.getAsync()).joinInternal();
    }

    @Override
    public long getAndAdd(long delta) {
        return (Long)((InternalCompletableFuture)this.getAndAddAsync(delta)).joinInternal();
    }

    @Override
    public long getAndSet(long newValue) {
        return (Long)((InternalCompletableFuture)this.getAndSetAsync(newValue)).joinInternal();
    }

    @Override
    public long incrementAndGet() {
        return (Long)((InternalCompletableFuture)this.incrementAndGetAsync()).joinInternal();
    }

    @Override
    public long getAndIncrement() {
        return (Long)((InternalCompletableFuture)this.getAndIncrementAsync()).joinInternal();
    }

    @Override
    public void set(long newValue) {
        ((InternalCompletableFuture)this.setAsync(newValue)).joinInternal();
    }

    @Override
    public void alter(IFunction<Long, Long> function) {
        ((InternalCompletableFuture)this.alterAsync((IFunction)function)).joinInternal();
    }

    @Override
    public long alterAndGet(IFunction<Long, Long> function) {
        return (Long)((InternalCompletableFuture)this.alterAndGetAsync((IFunction)function)).joinInternal();
    }

    @Override
    public long getAndAlter(IFunction<Long, Long> function) {
        return (Long)((InternalCompletableFuture)this.getAndAlterAsync((IFunction)function)).joinInternal();
    }

    @Override
    public <R> R apply(IFunction<Long, R> function) {
        return (R)((InternalCompletableFuture)this.applyAsync((IFunction)function)).joinInternal();
    }

    public InternalCompletableFuture<Long> addAndGetAsync(long delta) {
        ClientMessage request = AtomicLongAddAndGetCodec.encodeRequest(this.groupId, this.objectName, delta);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), AtomicLongAddAndGetCodec::decodeResponse);
    }

    public InternalCompletableFuture<Boolean> compareAndSetAsync(long expect, long update) {
        ClientMessage request = AtomicLongCompareAndSetCodec.encodeRequest(this.groupId, this.objectName, expect, update);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Boolean>(future, this.getSerializationService(), AtomicLongCompareAndSetCodec::decodeResponse);
    }

    public InternalCompletableFuture<Long> decrementAndGetAsync() {
        return this.addAndGetAsync(-1L);
    }

    public InternalCompletableFuture<Long> getAndDecrementAsync() {
        return this.getAndAddAsync(-1L);
    }

    public InternalCompletableFuture<Long> getAsync() {
        ClientMessage request = AtomicLongGetCodec.encodeRequest(this.groupId, this.objectName);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), AtomicLongGetCodec::decodeResponse);
    }

    public InternalCompletableFuture<Long> getAndAddAsync(long delta) {
        ClientMessage request = AtomicLongGetAndAddCodec.encodeRequest(this.groupId, this.objectName, delta);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), AtomicLongGetAndAddCodec::decodeResponse);
    }

    public InternalCompletableFuture<Long> getAndSetAsync(long newValue) {
        ClientMessage request = AtomicLongGetAndSetCodec.encodeRequest(this.groupId, this.objectName, newValue);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), AtomicLongGetAndSetCodec::decodeResponse);
    }

    public InternalCompletableFuture<Long> incrementAndGetAsync() {
        return this.addAndGetAsync(1L);
    }

    public InternalCompletableFuture<Long> getAndIncrementAsync() {
        return this.getAndAddAsync(1L);
    }

    public InternalCompletableFuture<Void> setAsync(long newValue) {
        return this.getAndSetAsync(newValue);
    }

    public InternalCompletableFuture<Void> alterAsync(IFunction<Long, Long> function) {
        return this.alterAndGetAsync((IFunction)function);
    }

    public InternalCompletableFuture<Long> alterAndGetAsync(IFunction<Long, Long> function) {
        Object f = this.getSerializationService().toData(function);
        ClientMessage request = AtomicLongAlterCodec.encodeRequest(this.groupId, this.objectName, f, AlterOp.AlterResultType.NEW_VALUE.value());
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), AtomicLongAlterCodec::decodeResponse);
    }

    public InternalCompletableFuture<Long> getAndAlterAsync(IFunction<Long, Long> function) {
        Object f = this.getSerializationService().toData(function);
        ClientMessage request = AtomicLongAlterCodec.encodeRequest(this.groupId, this.objectName, f, AlterOp.AlterResultType.OLD_VALUE.value());
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), AtomicLongAlterCodec::decodeResponse);
    }

    public <R> InternalCompletableFuture<R> applyAsync(IFunction<Long, R> function) {
        Object f = this.getSerializationService().toData(function);
        ClientMessage request = AtomicLongApplyCodec.encodeRequest(this.groupId, this.objectName, f);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), AtomicLongApplyCodec::decodeResponse);
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest(this.groupId, this.getServiceName(), this.objectName);
        new ClientInvocation(this.getClient(), request, this.name).invoke().joinInternal();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }
}

