/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.server;

import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.apache.camel.component.grpc.GrpcConsumer;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.GrpcUtils;
import org.apache.camel.component.grpc.server.BindableServiceFactory;
import org.apache.camel.component.grpc.server.GrpcMethodHandler;

public class DefaultBindableServiceFactory
implements BindableServiceFactory {
    @Override
    public BindableService createBindableService(final GrpcConsumer consumer) {
        GrpcEndpoint endpoint = (GrpcEndpoint)consumer.getEndpoint();
        ProxyFactory serviceProxy = new ProxyFactory();
        MethodHandler methodHandler = new MethodHandler(){
            private final GrpcMethodHandler grpcMethodHandler;
            {
                this.grpcMethodHandler = new GrpcMethodHandler(consumer);
            }

            public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                if (args.length != 2 || !(args[1] instanceof StreamObserver)) {
                    if (args.length == 1 && args[0] instanceof StreamObserver) {
                        return this.grpcMethodHandler.handleForConsumerStrategy((StreamObserver<Object>)((StreamObserver)args[0]), thisMethod.getName());
                    }
                    throw new IllegalArgumentException("Invalid to process gRPC method: " + thisMethod.getName());
                }
                this.grpcMethodHandler.handle(args[0], (StreamObserver<Object>)((StreamObserver)args[1]), thisMethod.getName());
                return null;
            }
        };
        serviceProxy.setSuperclass(GrpcUtils.constructGrpcImplBaseClass(endpoint.getServicePackage(), endpoint.getServiceName(), endpoint.getCamelContext()));
        try {
            return (BindableService)serviceProxy.create(new Class[0], new Object[0], methodHandler);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create bindable proxy service for " + endpoint.getConfiguration().getService());
        }
    }
}

