/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.graphql;

import java.net.URI;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.graphql.GraphqlEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.json.JsonObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class GraphqlProducer
extends DefaultAsyncProducer {
    public GraphqlProducer(GraphqlEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public GraphqlEndpoint getEndpoint() {
        return (GraphqlEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            CloseableHttpClient httpClient = this.getEndpoint().getHttpclient();
            URI httpUri = this.getEndpoint().getHttpUri();
            String requestBody = GraphqlProducer.buildRequestBody(this.getEndpoint().getQuery(), this.getEndpoint().getOperationName(), this.getEndpoint().getVariables());
            StringEntity requestEntity = new StringEntity(requestBody, ContentType.create((String)"application/json", (String)"UTF-8"));
            HttpPost httpPost = new HttpPost(httpUri);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Accept-Encoding", "gzip");
            httpPost.setEntity((HttpEntity)requestEntity);
            String responseContent = (String)httpClient.execute((HttpUriRequest)httpPost, response -> EntityUtils.toString((HttpEntity)response.getEntity()));
            exchange.getMessage().setBody((Object)responseContent);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    protected static String buildRequestBody(String query, String operationName, JsonObject variables) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put((Object)"query", (Object)query);
        jsonObject.put((Object)"operationName", (Object)operationName);
        jsonObject.put((Object)"variables", (Object)(variables != null ? variables : new JsonObject()));
        return jsonObject.toJson();
    }
}

