/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.SimpleMain;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.idempotent.kafka.KafkaIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.SensitiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelKafkaConnectMain
extends SimpleMain {
    public static final String CAMEL_DATAFORMAT_PROPERTIES_PREFIX = "camel.dataformat.";
    private static final Logger LOG = LoggerFactory.getLogger(CamelKafkaConnectMain.class);
    protected volatile ConsumerTemplate consumerTemplate;
    protected volatile ProducerTemplate producerTemplate;

    public CamelKafkaConnectMain(CamelContext context) {
        super(context);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.consumerTemplate);
        this.consumerTemplate = null;
        ServiceHelper.stopService((Object)this.producerTemplate);
        this.producerTemplate = null;
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerTemplate getProducerTemplate() {
        if (this.producerTemplate == null) {
            CamelKafkaConnectMain camelKafkaConnectMain = this;
            synchronized (camelKafkaConnectMain) {
                if (this.producerTemplate == null) {
                    this.producerTemplate = this.getCamelContext().createProducerTemplate();
                }
            }
        }
        return this.producerTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerTemplate getConsumerTemplate() {
        if (this.consumerTemplate == null) {
            CamelKafkaConnectMain camelKafkaConnectMain = this;
            synchronized (camelKafkaConnectMain) {
                if (this.consumerTemplate == null) {
                    this.consumerTemplate = this.getCamelContext().createConsumerTemplate();
                }
            }
        }
        return this.consumerTemplate;
    }

    public static Builder builder(String from, String to) {
        return new Builder(from, to);
    }

    public static final class Builder {
        private final String from;
        private final String to;
        private Map<String, String> props;
        private String marshallDataFormat;
        private String unmarshallDataFormat;
        private int aggregationSize;
        private long aggregationTimeout;
        private String errorHandler;
        private int maxRedeliveries;
        private long redeliveryDelay;
        private boolean idempotencyEnabled;
        private String expressionType;
        private String expressionHeader;
        private int memoryDimension;
        private String idempotentRepositoryType;
        private String idempotentRepositoryTopicName;
        private String idempotentRepositoryKafkaServers;
        private int idempotentRepositoryKafkaMaxCacheSize;
        private int idempotentRepositoryKafkaPollDuration;
        private String headersExcludePattern;

        public Builder(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public Builder withProperties(Map<String, String> props) {
            this.props = new HashMap<String, String>(props);
            return this;
        }

        public Builder withMarshallDataFormat(String dataformatId) {
            this.marshallDataFormat = dataformatId;
            return this;
        }

        public Builder withUnmarshallDataFormat(String dataformatId) {
            this.unmarshallDataFormat = dataformatId;
            return this;
        }

        public Builder withAggregationSize(int aggregationSize) {
            this.aggregationSize = aggregationSize;
            return this;
        }

        public Builder withAggregationTimeout(long aggregationTimeout) {
            this.aggregationTimeout = aggregationTimeout;
            return this;
        }

        public Builder withErrorHandler(String errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder withMaxRedeliveries(int maxRedeliveries) {
            this.maxRedeliveries = maxRedeliveries;
            return this;
        }

        public Builder withRedeliveryDelay(long redeliveryDelay) {
            this.redeliveryDelay = redeliveryDelay;
            return this;
        }

        public Builder withIdempotencyEnabled(boolean idempotencyEnabled) {
            this.idempotencyEnabled = idempotencyEnabled;
            return this;
        }

        public Builder withExpressionType(String expressionType) {
            this.expressionType = expressionType;
            return this;
        }

        public Builder withExpressionHeader(String expressionHeader) {
            this.expressionHeader = expressionHeader;
            return this;
        }

        public Builder withMemoryDimension(int memoryDimension) {
            this.memoryDimension = memoryDimension;
            return this;
        }

        public Builder withIdempotentRepositoryType(String idempotentRepositoryType) {
            this.idempotentRepositoryType = idempotentRepositoryType;
            return this;
        }

        public Builder withIdempotentRepositoryTopicName(String idempotentRepositoryTopicName) {
            this.idempotentRepositoryTopicName = idempotentRepositoryTopicName;
            return this;
        }

        public Builder withIdempotentRepositoryKafkaServers(String idempotentRepositoryKafkaServers) {
            this.idempotentRepositoryKafkaServers = idempotentRepositoryKafkaServers;
            return this;
        }

        public Builder withIdempotentRepositoryKafkaMaxCacheSize(int idempotentRepositoryKafkaMaxCacheSize) {
            this.idempotentRepositoryKafkaMaxCacheSize = idempotentRepositoryKafkaMaxCacheSize;
            return this;
        }

        public Builder withIdempotentRepositoryKafkaPollDuration(int idempotentRepositoryKafkaPollDuration) {
            this.idempotentRepositoryKafkaPollDuration = idempotentRepositoryKafkaPollDuration;
            return this;
        }

        public Builder withHeadersExcludePattern(String headersExcludePattern) {
            this.headersExcludePattern = headersExcludePattern;
            return this;
        }

        private String filterSensitive(Map.Entry<Object, Object> entry) {
            if (SensitiveUtils.containsSensitive((String)((String)entry.getKey()))) {
                return entry.getKey() + "=xxxxxxx";
            }
            return entry.getKey() + "=" + entry.getValue();
        }

        public CamelKafkaConnectMain build(CamelContext camelContext) {
            CamelKafkaConnectMain camelMain = new CamelKafkaConnectMain(camelContext);
            camelMain.configure().setAutoConfigurationLogSummary(false);
            Properties camelProperties = new Properties();
            camelProperties.putAll(this.props);
            List filteredProps = camelProperties.entrySet().stream().map(this::filterSensitive).collect(Collectors.toList());
            LOG.info("Setting initial properties in Camel context: [{}]", filteredProps);
            camelMain.setInitialProperties(camelProperties);
            if (this.idempotencyEnabled) {
                IdempotentRepository idempotentRepo = null;
                switch (this.idempotentRepositoryType) {
                    case "memory": {
                        idempotentRepo = MemoryIdempotentRepository.memoryIdempotentRepository((int)this.memoryDimension);
                        break;
                    }
                    case "kafka": {
                        idempotentRepo = new KafkaIdempotentRepository(this.idempotentRepositoryTopicName, this.idempotentRepositoryKafkaServers, this.idempotentRepositoryKafkaMaxCacheSize, this.idempotentRepositoryKafkaPollDuration);
                        break;
                    }
                }
                camelMain.getCamelContext().getRegistry().bind("idempotentRepository", (Object)idempotentRepo);
            }
            camelMain.configure().addRoutesBuilder((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    RouteDefinition rd = this.from(from);
                    LOG.info("Creating Camel route from({})", (Object)from);
                    if (!ObjectHelper.isEmpty((Object)errorHandler)) {
                        switch (errorHandler) {
                            case "no": {
                                rd.errorHandler((ErrorHandlerFactory)this.noErrorHandler());
                                break;
                            }
                            case "default": {
                                rd.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(maxRedeliveries).redeliveryDelay(redeliveryDelay));
                                break;
                            }
                        }
                    }
                    if (!ObjectHelper.isEmpty((Object)marshallDataFormat)) {
                        LOG.info(".marshal({})", (Object)marshallDataFormat);
                        rd.marshal(marshallDataFormat);
                    }
                    if (!ObjectHelper.isEmpty((Object)unmarshallDataFormat)) {
                        LOG.info(".unmarshal({})", (Object)unmarshallDataFormat);
                        rd.unmarshal(unmarshallDataFormat);
                    }
                    if (this.getContext().getRegistry().lookupByName("aggregate") != null) {
                        AggregationStrategy s = (AggregationStrategy)this.getContext().getRegistry().lookupByNameAndType("aggregate", AggregationStrategy.class);
                        if (idempotencyEnabled) {
                            switch (expressionType) {
                                case "body": {
                                    LOG.info(".aggregate({}).constant(true).completionSize({}).completionTimeout({}).idempotentConsumer(body(), + MemoryIdempotentRepository.memoryIdempotentRepository({}))", new Object[]{s, aggregationSize, aggregationTimeout, memoryDimension});
                                    LOG.info(".to({})", (Object)to);
                                    if (ObjectHelper.isEmpty((Object)headersExcludePattern)) {
                                        ((AggregateDefinition)rd.aggregate(s).constant((Object)true)).completionSize(aggregationSize).completionTimeout(aggregationTimeout).idempotentConsumer((Expression)this.body()).messageIdRepositoryRef("idempotentRepository").toD(to);
                                        break;
                                    }
                                    ((ExpressionNode)((AggregateDefinition)rd.aggregate(s).constant((Object)true)).completionSize(aggregationSize).completionTimeout(aggregationTimeout).idempotentConsumer((Expression)this.body()).messageIdRepositoryRef("idempotentRepository").removeHeaders(headersExcludePattern)).toD(to);
                                    break;
                                }
                                case "header": {
                                    LOG.info(".aggregate({}).constant(true).completionSize({}).completionTimeout({}).idempotentConsumer(header(expressionHeader), + MemoryIdempotentRepository.memoryIdempotentRepository({}))", new Object[]{s, aggregationSize, aggregationTimeout, memoryDimension});
                                    LOG.info(".to({})", (Object)to);
                                    if (ObjectHelper.isEmpty((Object)headersExcludePattern)) {
                                        ((AggregateDefinition)rd.aggregate(s).constant((Object)true)).completionSize(aggregationSize).completionTimeout(aggregationTimeout).idempotentConsumer((Expression)this.header(expressionHeader)).messageIdRepositoryRef("idempotentRepository").toD(to);
                                        break;
                                    }
                                    ((ExpressionNode)((AggregateDefinition)rd.aggregate(s).constant((Object)true)).completionSize(aggregationSize).completionTimeout(aggregationTimeout).idempotentConsumer((Expression)this.header(expressionHeader)).messageIdRepositoryRef("idempotentRepository").removeHeaders(headersExcludePattern)).toD(to);
                                    break;
                                }
                            }
                        } else {
                            LOG.info(".aggregate({}).constant(true).completionSize({}).completionTimeout({})", new Object[]{s, aggregationSize, aggregationTimeout});
                            LOG.info(".to({})", (Object)to);
                            if (ObjectHelper.isEmpty((Object)headersExcludePattern)) {
                                ((AggregateDefinition)rd.aggregate(s).constant((Object)true)).completionSize(aggregationSize).completionTimeout(aggregationTimeout).toD(to);
                            } else {
                                ((AggregateDefinition)((AggregateDefinition)rd.aggregate(s).constant((Object)true)).completionSize(aggregationSize).completionTimeout(aggregationTimeout).removeHeaders(headersExcludePattern)).toD(to);
                            }
                        }
                    } else if (idempotencyEnabled) {
                        switch (expressionType) {
                            case "body": {
                                LOG.info("idempotentConsumer(body(), MemoryIdempotentRepository.memoryIdempotentRepository({})).to({})", (Object)memoryDimension, (Object)to);
                                if (ObjectHelper.isEmpty((Object)headersExcludePattern)) {
                                    rd.idempotentConsumer((Expression)this.body()).messageIdRepositoryRef("idempotentRepository").toD(to);
                                    break;
                                }
                                ((ExpressionNode)rd.idempotentConsumer((Expression)this.body()).messageIdRepositoryRef("idempotentRepository").removeHeaders(headersExcludePattern)).toD(to);
                                break;
                            }
                            case "header": {
                                LOG.info("idempotentConsumer(header(expressionHeader), MemoryIdempotentRepository.memoryIdempotentRepository({})).to({})", (Object)memoryDimension, (Object)to);
                                if (ObjectHelper.isEmpty((Object)headersExcludePattern)) {
                                    rd.idempotentConsumer((Expression)this.header(expressionHeader)).messageIdRepositoryRef("idempotentRepository").toD(to);
                                    break;
                                }
                                ((ExpressionNode)rd.idempotentConsumer((Expression)this.header(expressionHeader)).messageIdRepositoryRef("idempotentRepository").removeHeaders(headersExcludePattern)).toD(to);
                                break;
                            }
                        }
                    } else {
                        LOG.info(".to({})", (Object)to);
                        if (ObjectHelper.isEmpty((Object)headersExcludePattern)) {
                            rd.toD(to);
                        } else {
                            ((RouteDefinition)rd.removeHeaders(headersExcludePattern)).toD(to);
                        }
                    }
                }
            });
            return camelMain;
        }
    }
}

