/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.ser;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.avro.AvroGenerator;
import com.fasterxml.jackson.dataformat.avro.ser.AvroWriteContext;
import org.apache.avro.generic.GenericArray;

public class ArrayWriteContext
extends AvroWriteContext {
    protected final GenericArray<Object> _array;

    public ArrayWriteContext(AvroWriteContext parent, AvroGenerator generator, GenericArray<Object> array, Object currValue) {
        super(1, parent, generator, array.getSchema(), currValue);
        this._array = array;
    }

    @Override
    public Object rawValue() {
        return this._array;
    }

    @Override
    public final AvroWriteContext createChildArrayContext(Object currValue) throws JsonMappingException {
        GenericArray<Object> arr = this._createArray(this._schema.getElementType());
        this._array.add(arr);
        return new ArrayWriteContext(this, this._generator, arr, currValue);
    }

    @Override
    public AvroWriteContext createChildObjectContext(Object currValue) throws JsonMappingException {
        AvroWriteContext child = this._createObjectContext(this._schema.getElementType(), currValue);
        this._array.add(child.rawValue());
        return child;
    }

    @Override
    public void writeValue(Object value) {
        this._array.add(value);
    }

    @Override
    public void writeString(String value) {
        this._array.add((Object)value);
    }

    @Override
    public void writeNull() throws JsonMappingException {
        this._array.add(null);
    }

    @Override
    public void appendDesc(StringBuilder sb) {
        sb.append('[');
        sb.append(this.getCurrentIndex());
        sb.append(']');
    }
}

