/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Delayer;
import org.apache.camel.reifier.ExpressionReifier;

public class DelayReifier
extends ExpressionReifier<DelayDefinition> {
    public DelayReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ExpressionNode)DelayDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor childProcessor = this.createChildProcessor(false);
        Expression delay = this.createAbsoluteTimeDelayExpression();
        boolean async = this.parseBoolean(((DelayDefinition)this.definition).getAsyncDelayed(), true);
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)this.definition, async);
        ScheduledExecutorService threadPool = this.getConfiguredScheduledExecutorService("Delay", (ExecutorServiceAwareDefinition)this.definition, async);
        Delayer answer = new Delayer(this.camelContext, childProcessor, delay, threadPool, shutdownThreadPool);
        answer.setAsyncDelayed(async);
        answer.setCallerRunsWhenRejected(this.parseBoolean(((DelayDefinition)this.definition).getCallerRunsWhenRejected(), true));
        return answer;
    }

    private Expression createAbsoluteTimeDelayExpression() {
        return ((DelayDefinition)this.definition).getExpression() != null ? this.createExpression(((DelayDefinition)this.definition).getExpression()) : null;
    }
}

