/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format;

import java.util.Arrays;
import java.util.Objects;

public enum SchemaType {
    PROTOBUF("protobuf"),
    AVRO("avsc"),
    JSON("json");

    private static final SchemaType[] VALUES;
    private final String schemaType;

    private SchemaType(String type) {
        this.schemaType = type;
    }

    public String type() {
        return this.schemaType;
    }

    public static SchemaType of(String type) {
        return Arrays.stream(VALUES).filter(s -> Objects.equals(s.schemaType, type)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported schema type '%s'", type)));
    }

    static {
        VALUES = SchemaType.values();
    }
}

