/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format;

import java.util.Objects;

public enum MimeType {
    JSON("application/json"),
    PROTOBUF("application/protobuf"),
    AVRO("application/avro"),
    AVRO_BINARY("avro/binary"),
    AVRO_STRUCT("avro/x-struct"),
    BINARY("application/octet-stream"),
    TEXT("text/plain"),
    JAVA_OBJECT("application/x-java-object"),
    STRUCT("application/x-struct");

    private static final MimeType[] VALUES;
    private final String type;

    private MimeType(String type) {
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    public static MimeType of(String type) {
        for (MimeType mt : VALUES) {
            if (!Objects.equals(type, mt.type)) continue;
            return mt;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    static {
        VALUES = MimeType.values();
    }
}

