/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.gax.rpc.ApiException;

final class StatusUtil {
    private StatusUtil() {
    }

    static boolean isRetryable(Throwable error) {
        if (!(error instanceof ApiException)) {
            return true;
        }
        ApiException apiException = (ApiException)error;
        switch (apiException.getStatusCode().getCode()) {
            case DEADLINE_EXCEEDED: 
            case INTERNAL: 
            case CANCELLED: 
            case RESOURCE_EXHAUSTED: 
            case ABORTED: {
                return true;
            }
            case UNAVAILABLE: {
                return !apiException.getMessage().contains("Server shutdownNow invoked");
            }
        }
        return false;
    }
}

