/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.format.i18n;

import com.worldturner.medeia.format.i18n.BootstringKt;
import com.worldturner.medeia.format.i18n.BootstringParameters;
import com.worldturner.util.CodePointsKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lcom/worldturner/medeia/format/i18n/Bootstring;", "", "()V", "adapt", "", "delta", "numPoints", "firstTime", "", "p", "Lcom/worldturner/medeia/format/i18n/BootstringParameters;", "encode", "", "s", "medeia-validator-core"})
public final class Bootstring {
    public static final Bootstring INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String encode(@NotNull String s, @NotNull BootstringParameters p) {
        int b;
        int it;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        StringBuilder builder = new StringBuilder();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = p.getInitialN();
        int delta = 0;
        int bias = p.getInitialBias();
        Collection<Integer> codePoints = CodePointsKt.toCodePoints(s);
        Iterable $receiver$iv = codePoints;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $receiver$iv) {
                it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!p.isBasicCodePoint(it) || (it = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int h = b = n;
        Iterable $receiver$iv2 = codePoints;
        for (Object element$iv : $receiver$iv2) {
            it = ((Number)element$iv).intValue();
            boolean bl = false;
            if (p.isBasicCodePoint(it)) {
                builder.appendCodePoint(it);
                continue;
            }
            if (it >= p.getInitialN()) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        if (b > 0) {
            builder.appendCodePoint(p.getDelimiter());
        }
        while (h < codePoints.size()) {
            void n2;
            Integer n3 = BootstringKt.access$minIf(codePoints, (Function1)new Function1<Integer, Boolean>((Ref.IntRef)n2){
                final /* synthetic */ Ref.IntRef $n;

                public final boolean invoke(int it) {
                    return it >= this.$n.element;
                }
                {
                    this.$n = intRef;
                    super(1);
                }
            });
            if (n3 == null) {
                Intrinsics.throwNpe();
            }
            int m2 = n3;
            delta += (m2 - n2.element) * (h + 1);
            n2.element = m2;
            Iterator<Integer> iterator2 = codePoints.iterator();
            while (iterator2.hasNext()) {
                int t;
                int c = ((Number)iterator2.next()).intValue();
                if (c < n2.element || p.isBasicCodePoint(c)) {
                    ++delta;
                    continue;
                }
                if (c != n2.element) continue;
                int q = delta;
                int k = p.getBase();
                while (q >= (t = BootstringKt.access$restrictRange(k - bias, p.getTmin(), p.getTmax()))) {
                    int digit = t + (q - t) % (p.getBase() - t);
                    builder.appendCodePoint(p.digitToBasicCodePoint(digit));
                    q = (q - t) / (p.getBase() - t);
                    k += p.getBase();
                }
                builder.appendCodePoint(p.digitToBasicCodePoint(q));
                bias = this.adapt(delta, h + 1, h == b, p);
                delta = 0;
                ++h;
            }
            ++delta;
            int n4 = n2.element;
            n2.element = n4 + 1;
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    private final int adapt(int delta, int numPoints, boolean firstTime, BootstringParameters p) {
        int workingDelta = firstTime ? delta / p.getDamp() : delta / 2;
        workingDelta += workingDelta / numPoints;
        int k = 0;
        while (workingDelta > (p.getBase() - p.getTmin()) * p.getTmax() / 2) {
            workingDelta /= p.getBase() - p.getTmin();
            k += p.getBase();
        }
        return k + (p.getBase() - p.getTmin() + 1) * workingDelta / (workingDelta + p.getSkew());
    }

    private Bootstring() {
    }

    static {
        Bootstring bootstring;
        INSTANCE = bootstring = new Bootstring();
    }
}

