/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.functions;

import com.google.cloud.functions.v1.CloudFunctionsServiceClient;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsClientFactory;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsComponent;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsConfiguration;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.9.0", scheme="google-functions", title="Google Cloud Functions", syntax="google-functions:functionName", category={Category.CLOUD}, producerOnly=true)
public class GoogleCloudFunctionsEndpoint
extends DefaultEndpoint {
    @UriParam
    private GoogleCloudFunctionsConfiguration configuration;
    private CloudFunctionsServiceClient cloudFunctionsClient;

    public GoogleCloudFunctionsEndpoint(String uri, GoogleCloudFunctionsComponent component, GoogleCloudFunctionsConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new GoogleCloudFunctionsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from the google-functions endpoint: " + this.getEndpointUri());
    }

    public GoogleCloudFunctionsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GoogleCloudFunctionsConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.cloudFunctionsClient = this.configuration.getClient() != null ? this.configuration.getClient() : GoogleCloudFunctionsClientFactory.create(this.getCamelContext(), this.configuration);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.configuration.getClient() == null && this.cloudFunctionsClient != null) {
            this.cloudFunctionsClient.close();
        }
    }

    public CloudFunctionsServiceClient getClient() {
        return this.cloudFunctionsClient;
    }
}

