/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationMode;
import org.apache.camel.dsl.yaml.common.YamlSupport;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedNodeTypeException;
import org.apache.camel.dsl.yaml.common.exception.YamlDeserializationException;
import org.apache.camel.model.Block;
import org.apache.camel.model.OutputNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

public class YamlDeserializerSupport {
    protected YamlDeserializerSupport() {
    }

    public static Class<?> asClass(String val) throws YamlDeserializationException {
        try {
            return Class.forName(val);
        }
        catch (ClassNotFoundException e) {
            throw new YamlDeserializationException("Unable to load class " + val, e);
        }
    }

    public static Class<?>[] asClassArray(String val) throws YamlDeserializationException {
        String[] values = val.split(" ");
        Class[] cls = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            cls[i] = YamlDeserializerSupport.asClass(values[i]);
        }
        return cls;
    }

    public static byte[] asByteArray(String val) {
        return Base64.getDecoder().decode(val);
    }

    public static List<String> asStringList(String val) {
        return Arrays.asList(val.split(" "));
    }

    public static Set<String> asStringSet(String val) {
        return CollectionHelper.createSetContaining((Object[])val.split(" "));
    }

    public static byte[] asByteArray(Node node) {
        if (node == null) {
            return null;
        }
        return YamlDeserializerSupport.asByteArray(YamlDeserializerSupport.asText(node));
    }

    public static Class<?> asClass(Node node) {
        if (node == null) {
            return null;
        }
        return YamlDeserializerSupport.asClass(YamlDeserializerSupport.asText(node));
    }

    public static List<String> asStringList(Node node) {
        List<String> answer;
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == NodeType.SCALAR) {
            answer = YamlDeserializerSupport.asStringList(YamlDeserializerSupport.asText(node));
        } else if (node.getNodeType() == NodeType.SEQUENCE) {
            answer = new ArrayList<String>();
            for (Node item : YamlDeserializerSupport.asSequenceNode(node).getValue()) {
                answer.add(YamlDeserializerSupport.asText(item));
            }
        } else {
            throw new UnsupportedNodeTypeException(node);
        }
        return answer;
    }

    public static Set<String> asStringSet(Node node) {
        Set<String> answer;
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == NodeType.SCALAR) {
            answer = YamlDeserializerSupport.asStringSet(YamlDeserializerSupport.asText(node));
        } else if (node.getNodeType() == NodeType.SEQUENCE) {
            answer = new LinkedHashSet<String>();
            for (Node item : YamlDeserializerSupport.asSequenceNode(node).getValue()) {
                answer.add(YamlDeserializerSupport.asText(item));
            }
        } else {
            throw new UnsupportedNodeTypeException(node);
        }
        return answer;
    }

    public static Class<?>[] asClassArray(Node node) throws YamlDeserializationException {
        if (node == null) {
            return null;
        }
        return YamlDeserializerSupport.asClassArray(YamlDeserializerSupport.asText(node));
    }

    public static String asText(Node node) throws YamlDeserializationException {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != NodeType.SCALAR) {
            throw new IllegalArgumentException("Node is not SCALAR");
        }
        return ((ScalarNode)node).getValue();
    }

    public static <T> T asEnum(Node node, Class<T> type) throws YamlDeserializationException {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != NodeType.SCALAR) {
            throw new IllegalArgumentException("Node is not SCALAR");
        }
        String text = ((ScalarNode)node).getValue();
        return YamlDeserializerSupport.enumConverter(type, text);
    }

    public static Map<String, Object> asMap(Node node) {
        if (node == null) {
            return null;
        }
        MappingNode mn = YamlDeserializerSupport.asMappingNode(node);
        HashMap<String, Object> answer = new HashMap<String, Object>();
        block4: for (NodeTuple tuple : mn.getValue()) {
            String key = YamlDeserializerSupport.asText(tuple.getKeyNode());
            Node val = tuple.getValueNode();
            switch (val.getNodeType()) {
                case SCALAR: {
                    answer.put(StringHelper.dashToCamelCase((String)key), YamlDeserializerSupport.asText(val));
                    continue block4;
                }
                case MAPPING: {
                    answer.put(StringHelper.dashToCamelCase((String)key), YamlDeserializerSupport.asMap(val));
                    continue block4;
                }
            }
            throw new UnsupportedNodeTypeException(node);
        }
        return answer;
    }

    public static Map<String, Object> asScalarMap(Node node) {
        if (node == null) {
            return null;
        }
        MappingNode mn = YamlDeserializerSupport.asMappingNode(node);
        HashMap<String, Object> answer = new HashMap<String, Object>();
        block3: for (NodeTuple tuple : mn.getValue()) {
            String key = YamlDeserializerSupport.asText(tuple.getKeyNode());
            Node val = tuple.getValueNode();
            switch (val.getNodeType()) {
                case SCALAR: {
                    answer.put(StringHelper.dashToCamelCase((String)key), YamlDeserializerSupport.asText(val));
                    continue block3;
                }
            }
            throw new UnsupportedNodeTypeException(node);
        }
        return answer;
    }

    public static boolean asBoolean(Node node) throws YamlDeserializationException {
        return Boolean.parseBoolean(YamlDeserializerSupport.asText(node));
    }

    public static int asInt(Node node) throws YamlDeserializationException {
        return Integer.parseInt(YamlDeserializerSupport.asText(node));
    }

    public static long asLong(Node node) throws YamlDeserializationException {
        return Long.parseLong(YamlDeserializerSupport.asText(node));
    }

    public static double asDouble(Node node) throws YamlDeserializationException {
        return Double.parseDouble(YamlDeserializerSupport.asText(node));
    }

    public static MappingNode asMappingNode(Node node) throws YamlDeserializationException {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != NodeType.MAPPING) {
            throw new IllegalArgumentException("Node is not MAPPING");
        }
        return (MappingNode)node;
    }

    public static SequenceNode asSequenceNode(Node node) throws YamlDeserializationException {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != NodeType.SEQUENCE) {
            throw new IllegalArgumentException("Node is not MAPPING");
        }
        return (SequenceNode)node;
    }

    public static Node getNamedNode(MappingNode node, String name) throws YamlDeserializationException {
        if (node == null) {
            return null;
        }
        for (NodeTuple tuple : node.getValue()) {
            if (!name.equals(YamlDeserializerSupport.asText(tuple.getKeyNode()))) continue;
            return tuple.getValueNode();
        }
        return null;
    }

    public static <T> List<T> asNestedList(Node node, Class<T> type) throws YamlDeserializationException {
        ArrayList answer = new ArrayList();
        YamlDeserializerSupport.asNestedCollection(node, type, answer);
        return answer;
    }

    public static <T> List<T> asFlatList(Node node, Class<T> type) throws YamlDeserializationException {
        ArrayList answer = new ArrayList();
        YamlDeserializerSupport.asFlatCollection(node, type, answer);
        return answer;
    }

    public static <T> Set<T> asNestedSet(Node node, Class<T> type) throws YamlDeserializationException {
        HashSet answer = new HashSet();
        YamlDeserializerSupport.asNestedCollection(node, type, answer);
        return answer;
    }

    public static <T> Set<T> asFlatSet(Node node, Class<T> type) throws YamlDeserializationException {
        HashSet answer = new HashSet();
        YamlDeserializerSupport.asFlatCollection(node, type, answer);
        return answer;
    }

    public static <T> void asNestedCollection(Node node, Class<T> type, Collection<T> collection) throws YamlDeserializationException {
        YamlDeserializerSupport.asCollection(node, type, collection, false);
    }

    public static <T> void asFlatCollection(Node node, Class<T> type, Collection<T> collection) throws YamlDeserializationException {
        YamlDeserializerSupport.asCollection(node, type, collection, true);
    }

    private static <T> void asCollection(Node node, Class<T> type, Collection<T> collection, boolean flat) throws YamlDeserializationException {
        if (node.getNodeType() != NodeType.SEQUENCE) {
            throw new UnsupportedOperationException("Unable to parse no array node");
        }
        YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext(node);
        if (dc == null) {
            throw new IllegalArgumentException("Unable to find YamlConstructor");
        }
        for (Node element : YamlDeserializerSupport.asSequenceNode(node).getValue()) {
            T instance;
            Node val = YamlDeserializerSupport.setDeserializationContext(element, dc);
            if (flat) {
                instance = YamlDeserializerSupport.asType(val, type);
            } else {
                ConstructNode cn = dc.mandatoryResolve(val);
                instance = type.cast(cn.construct(val));
            }
            collection.add(instance);
        }
    }

    public static <T> T asType(Node node, Class<T> type) throws YamlDeserializationException {
        YamlDeserializationContext resolver = (YamlDeserializationContext)((Object)node.getProperty(YamlDeserializationContext.class.getName()));
        if (resolver == null) {
            throw new IllegalArgumentException("Unable to find YamlConstructor");
        }
        ConstructNode construct = resolver.resolve(type);
        if (construct == null) {
            throw new IllegalArgumentException("Unable to determine constructor for type: " + type.getName());
        }
        return (T)construct.construct(node);
    }

    public static String asEndpoint(Node node) {
        return YamlDeserializerSupport.asEndpoint(YamlDeserializerSupport.asMappingNode(node));
    }

    public static String asEndpoint(MappingNode node) {
        YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext((Node)node);
        CamelContext cc = dc.getCamelContext();
        String uri = null;
        Map<String, Object> properties = null;
        block8: for (NodeTuple tuple : node.getValue()) {
            String key = YamlDeserializerSupport.asText(tuple.getKeyNode());
            Node val = tuple.getValueNode();
            YamlDeserializerSupport.setDeserializationContext(val, dc);
            switch (key) {
                case "uri": {
                    uri = YamlDeserializerSupport.asText(val);
                    continue block8;
                }
                case "properties": {
                    properties = YamlDeserializerSupport.asScalarMap(tuple.getValueNode());
                    continue block8;
                }
            }
            throw new UnsupportedFieldException((Node)node, key);
        }
        return YamlSupport.createEndpointUri(cc, uri, properties);
    }

    public static YamlDeserializationContext getDeserializationContext(Node node) {
        return (YamlDeserializationContext)((Object)node.getProperty(YamlDeserializationContext.class.getName()));
    }

    public static Node setDeserializationContext(Node node, YamlDeserializationContext context) {
        node.setProperty(YamlDeserializationContext.class.getName(), (Object)context);
        return node;
    }

    public static void setSteps(Block target, Node node) {
        YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext(node);
        Block block = target;
        for (ProcessorDefinition definition : YamlDeserializerSupport.asFlatList(node, ProcessorDefinition.class)) {
            block.addOutput(definition);
            if (dc.getDeserializationMode() != YamlDeserializationMode.FLOW || !(definition instanceof OutputNode) || !ObjectHelper.isEmpty((Object)definition.getOutputs())) continue;
            block = definition;
        }
    }

    public static Node nodeAt(Node root, String pointer) {
        if (ObjectHelper.isEmpty((Object)pointer)) {
            return root;
        }
        MappingNode mn = YamlDeserializerSupport.asMappingNode(root);
        for (String path : pointer.split("/")) {
            for (NodeTuple child : mn.getValue()) {
                ScalarNode scalar;
                if (!(child.getKeyNode() instanceof ScalarNode) || !(scalar = (ScalarNode)child.getKeyNode()).getValue().equals(path)) continue;
                String next = pointer.substring(path.length() + 1);
                return ObjectHelper.isEmpty((Object)next) ? child.getValueNode() : YamlDeserializerSupport.nodeAt(child.getValueNode(), next);
            }
        }
        return null;
    }

    public static <T> T enumConverter(Class<T> type, String value) {
        if (type.isEnum()) {
            String text = value.toString();
            Class<T> enumClass = type;
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(text)) continue;
                return type.cast(enumValue);
            }
            text = StringHelper.asEnumConstantValue((String)text);
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(text)) continue;
                return type.cast(enumValue);
            }
            throw new IllegalArgumentException("Enum class " + type + " does not have any constant with value: " + text);
        }
        return null;
    }
}

