/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.CircularIterator;
import org.apache.kafka.common.utils.Utils;

public class RoundRobinAssignor
extends AbstractPartitionAssignor {
    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        HashMap<String, List<TopicPartition>> assignment = new HashMap<String, List<TopicPartition>>();
        ArrayList<AbstractPartitionAssignor.MemberInfo> memberInfoList = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> memberSubscription : subscriptions.entrySet()) {
            assignment.put(memberSubscription.getKey(), new ArrayList());
            memberInfoList.add(new AbstractPartitionAssignor.MemberInfo(memberSubscription.getKey(), memberSubscription.getValue().groupInstanceId()));
        }
        CircularIterator assigner = new CircularIterator(Utils.sorted(memberInfoList));
        for (TopicPartition partition : this.allPartitionsSorted(partitionsPerTopic, subscriptions)) {
            String topic = partition.topic();
            while (!subscriptions.get(((AbstractPartitionAssignor.MemberInfo)assigner.peek()).memberId).topics().contains(topic)) {
                assigner.next();
            }
            ((List)assignment.get(((AbstractPartitionAssignor.MemberInfo)assigner.next()).memberId)).add(partition);
        }
        return assignment;
    }

    private List<TopicPartition> allPartitionsSorted(Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        TreeSet<String> topics = new TreeSet<String>();
        for (ConsumerPartitionAssignor.Subscription subscription : subscriptions.values()) {
            topics.addAll(subscription.topics());
        }
        ArrayList<TopicPartition> allPartitions = new ArrayList<TopicPartition>();
        for (String topic : topics) {
            Integer numPartitionsForTopic = partitionsPerTopic.get(topic);
            if (numPartitionsForTopic == null) continue;
            allPartitions.addAll(AbstractPartitionAssignor.partitions(topic, numPartitionsForTopic));
        }
        return allPartitions;
    }

    @Override
    public String name() {
        return "roundrobin";
    }
}

