/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.common.base.Preconditions;
import java.util.concurrent.ThreadLocalRandom;
import org.threeten.bp.Duration;

public class ExponentialRetryAlgorithm
implements TimedRetryAlgorithm {
    private final RetrySettings globalSettings;
    private final ApiClock clock;

    public ExponentialRetryAlgorithm(RetrySettings globalSettings, ApiClock clock) {
        this.globalSettings = (RetrySettings)Preconditions.checkNotNull((Object)globalSettings);
        this.clock = (ApiClock)Preconditions.checkNotNull((Object)clock);
    }

    @Override
    public TimedAttemptSettings createFirstAttempt() {
        return TimedAttemptSettings.newBuilder().setGlobalSettings(this.globalSettings).setRetryDelay(Duration.ZERO).setRpcTimeout(this.globalSettings.getInitialRpcTimeout()).setRandomizedRetryDelay(Duration.ZERO).setAttemptCount(0).setOverallAttemptCount(0).setFirstAttemptStartTimeNanos(this.clock.nanoTime()).build();
    }

    @Override
    public TimedAttemptSettings createNextAttempt(TimedAttemptSettings prevSettings) {
        RetrySettings settings = prevSettings.getGlobalSettings();
        long newRetryDelay = settings.getInitialRetryDelay().toMillis();
        if (prevSettings.getAttemptCount() > 0) {
            newRetryDelay = (long)(settings.getRetryDelayMultiplier() * (double)prevSettings.getRetryDelay().toMillis());
            newRetryDelay = Math.min(newRetryDelay, settings.getMaxRetryDelay().toMillis());
        }
        Duration randomDelay = Duration.ofMillis((long)this.nextRandomLong(newRetryDelay));
        long newRpcTimeout = (long)(settings.getRpcTimeoutMultiplier() * (double)prevSettings.getRpcTimeout().toMillis());
        newRpcTimeout = Math.min(newRpcTimeout, settings.getMaxRpcTimeout().toMillis());
        if (!settings.getTotalTimeout().isZero()) {
            Duration timeElapsed = Duration.ofNanos((long)this.clock.nanoTime()).minus(Duration.ofNanos((long)prevSettings.getFirstAttemptStartTimeNanos()));
            Duration timeLeft = this.globalSettings.getTotalTimeout().minus(timeElapsed).minus(randomDelay);
            newRpcTimeout = Math.min(newRpcTimeout, timeLeft.toMillis());
        }
        return TimedAttemptSettings.newBuilder().setGlobalSettings(prevSettings.getGlobalSettings()).setRetryDelay(Duration.ofMillis((long)newRetryDelay)).setRpcTimeout(Duration.ofMillis((long)newRpcTimeout)).setRandomizedRetryDelay(randomDelay).setAttemptCount(prevSettings.getAttemptCount() + 1).setOverallAttemptCount(prevSettings.getOverallAttemptCount() + 1).setFirstAttemptStartTimeNanos(prevSettings.getFirstAttemptStartTimeNanos()).build();
    }

    @Override
    public boolean shouldRetry(TimedAttemptSettings nextAttemptSettings) {
        RetrySettings globalSettings = nextAttemptSettings.getGlobalSettings();
        int maxAttempts = globalSettings.getMaxAttempts();
        long totalTimeout = globalSettings.getTotalTimeout().toNanos();
        if (totalTimeout == 0L && maxAttempts == 0) {
            return false;
        }
        long totalTimeSpentNanos = this.clock.nanoTime() - nextAttemptSettings.getFirstAttemptStartTimeNanos() + nextAttemptSettings.getRandomizedRetryDelay().toNanos();
        if (totalTimeout > 0L && totalTimeSpentNanos > totalTimeout) {
            return false;
        }
        return maxAttempts <= 0 || nextAttemptSettings.getAttemptCount() < maxAttempts;
    }

    protected long nextRandomLong(long bound) {
        return bound > 0L && this.globalSettings.isJittered() ? ThreadLocalRandom.current().nextLong(bound) : bound;
    }
}

