/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.JobException;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLConfiguration;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLEndpoint;
import org.apache.camel.component.google.bigquery.sql.SqlHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBigQuerySQLProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleBigQuerySQLProducer.class);
    private final GoogleBigQuerySQLConfiguration configuration;
    private BigQuery bigquery;
    private String query;
    private Set<String> queryParameterNames;

    public GoogleBigQuerySQLProducer(BigQuery bigquery, GoogleBigQuerySQLEndpoint endpoint, GoogleBigQuerySQLConfiguration configuration) {
        super((Endpoint)endpoint);
        this.bigquery = bigquery;
        this.configuration = configuration;
    }

    public void process(Exchange exchange) throws Exception {
        String translatedQuery = SqlHelper.translateQuery(this.query, exchange);
        Map<String, Object> queryParameters = this.extractParameters(exchange);
        Message message = exchange.getMessage();
        message.setHeader("CamelGoogleBigQueryTranslatedQuery", (Object)translatedQuery);
        JobId jobId = (JobId)message.getHeader("CamelGoogleBigQueryJobId", JobId.class);
        Long affectedRows = this.executeSQL(jobId, translatedQuery, queryParameters);
        LOG.debug("The query {} affected {} rows", (Object)this.query, (Object)affectedRows);
        message.setBody((Object)affectedRows);
    }

    private Long executeSQL(JobId jobId, String translatedQuery, Map<String, Object> queryParameters) throws Exception {
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)translatedQuery).setUseLegacySql(Boolean.valueOf(false));
        this.setQueryParameters(queryParameters, builder);
        QueryJobConfiguration queryJobConfiguration = builder.build();
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sending query to bigquery standard sql: {}", (Object)translatedQuery);
            }
            JobId queryJobId = ObjectHelper.isNotEmpty((Object)jobId) ? jobId : JobId.of((String)this.configuration.getProjectId(), (String)UUID.randomUUID().toString());
            TableResult result = this.bigquery.query(queryJobConfiguration, queryJobId, new BigQuery.JobOption[0]);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Result of query {} is {}", (Object)translatedQuery, (Object)result.toString());
            }
            return result.getTotalRows();
        }
        catch (JobException e) {
            throw new Exception("Query " + translatedQuery + " failed: " + e.getErrors(), e);
        }
        catch (BigQueryException e) {
            throw new Exception("Query " + translatedQuery + " failed: " + e.getError(), e);
        }
    }

    private Map<String, Object> extractParameters(Exchange exchange) {
        if (this.queryParameterNames == null || this.queryParameterNames.size() == 0) {
            return null;
        }
        Message message = exchange.getMessage();
        HashMap headers = new HashMap(message.getHeaders());
        if (message.getBody() instanceof Map) {
            try {
                headers.putAll((Map)message.getBody(Map.class));
            }
            catch (ClassCastException e) {
                LOG.warn("Unable to perform cast while extracting header parameters: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.queryParameterNames.size());
        this.queryParameterNames.forEach(s -> {
            Object value = headers.get(s);
            if (value == null) {
                throw new RuntimeExchangeException("SQL parameter with name '" + s + "' not found in the message headers", exchange);
            }
            result.put((String)s, headers.get(s));
        });
        return result;
    }

    private void setQueryParameters(Map<String, Object> params, QueryJobConfiguration.Builder builder) {
        if (params == null) {
            return;
        }
        params.forEach((key, value) -> {
            QueryParameterValue parameterValue = QueryParameterValue.of((Object)value.toString(), (StandardSQLTypeName)StandardSQLTypeName.STRING);
            builder.addNamedParameter(key, parameterValue);
        });
    }

    public GoogleBigQuerySQLEndpoint getEndpoint() {
        return (GoogleBigQuerySQLEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        String placeholder = ":#";
        this.query = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), this.configuration.getQuery(), placeholder);
        this.queryParameterNames = SqlHelper.extractParameterNames(this.query);
    }
}

