/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.QueryParameter;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class QueryJobConfiguration
extends JobConfiguration {
    private static final long serialVersionUID = -1108948249081804890L;
    private final String query;
    private final ImmutableList<QueryParameterValue> positionalParameters;
    private final ImmutableMap<String, QueryParameterValue> namedParameters;
    private final TableId destinationTable;
    private final Map<String, ExternalTableDefinition> tableDefinitions;
    private final List<UserDefinedFunction> userDefinedFunctions;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final DatasetId defaultDataset;
    private final Priority priority;
    private final Boolean allowLargeResults;
    private final Boolean useQueryCache;
    private final Boolean flattenResults;
    private final Boolean dryRun;
    private final Boolean useLegacySql;
    private final Integer maximumBillingTier;
    private final Long maximumBytesBilled;
    private final List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
    private final EncryptionConfiguration destinationEncryptionConfiguration;
    private final TimePartitioning timePartitioning;
    private final Clustering clustering;
    private final Long jobTimeoutMs;
    private final Map<String, String> labels;
    private final RangePartitioning rangePartitioning;
    private final List<ConnectionProperty> connectionProperties;
    private final Long maxResults;
    private final String requestId;
    private static final Function<QueryParameter, QueryParameterValue> POSITIONAL_PARAMETER_FROM_PB_FUNCTION = new Function<QueryParameter, QueryParameterValue>(){

        public QueryParameterValue apply(QueryParameter pb) {
            Preconditions.checkArgument((pb.getName() == null ? 1 : 0) != 0);
            return QueryParameterValue.fromPb(pb.getParameterValue(), pb.getParameterType());
        }
    };
    private static final Function<QueryParameterValue, QueryParameter> POSITIONAL_PARAMETER_TO_PB_FUNCTION = new Function<QueryParameterValue, QueryParameter>(){

        public QueryParameter apply(QueryParameterValue value) {
            QueryParameter queryParameterPb = new QueryParameter();
            queryParameterPb.setParameterValue(value.toValuePb());
            queryParameterPb.setParameterType(value.toTypePb());
            return queryParameterPb;
        }
    };
    private static final Function<Map.Entry<String, QueryParameterValue>, QueryParameter> NAMED_PARAMETER_TO_PB_FUNCTION = new Function<Map.Entry<String, QueryParameterValue>, QueryParameter>(){

        public QueryParameter apply(Map.Entry<String, QueryParameterValue> entry) {
            QueryParameter queryParameterPb = new QueryParameter();
            queryParameterPb.setName(entry.getKey());
            queryParameterPb.setParameterValue(entry.getValue().toValuePb());
            queryParameterPb.setParameterType(entry.getValue().toTypePb());
            return queryParameterPb;
        }
    };

    private QueryJobConfiguration(Builder builder) {
        super(builder);
        this.query = (String)Preconditions.checkNotNull((Object)builder.query);
        Preconditions.checkNotNull((Object)builder.positionalParameters);
        Preconditions.checkNotNull((Object)builder.namedParameters);
        if (!builder.positionalParameters.isEmpty()) {
            Preconditions.checkArgument((boolean)builder.namedParameters.isEmpty());
        }
        if (!builder.namedParameters.isEmpty()) {
            Preconditions.checkArgument((boolean)builder.positionalParameters.isEmpty());
        }
        this.positionalParameters = ImmutableList.copyOf((Collection)builder.positionalParameters);
        this.namedParameters = ImmutableMap.copyOf((Map)builder.namedParameters);
        this.allowLargeResults = builder.allowLargeResults;
        this.createDisposition = builder.createDisposition;
        this.defaultDataset = builder.defaultDataset;
        this.destinationTable = builder.destinationTable;
        this.flattenResults = builder.flattenResults;
        this.priority = builder.priority;
        this.useQueryCache = builder.useQueryCache;
        this.userDefinedFunctions = builder.userDefinedFunctions;
        this.writeDisposition = builder.writeDisposition;
        this.tableDefinitions = builder.tableDefinitions != null ? ImmutableMap.copyOf((Map)builder.tableDefinitions) : null;
        this.dryRun = builder.dryRun;
        this.useLegacySql = builder.useLegacySql;
        this.maximumBillingTier = builder.maximumBillingTier;
        this.maximumBytesBilled = builder.maximumBytesBilled;
        this.schemaUpdateOptions = builder.schemaUpdateOptions;
        this.destinationEncryptionConfiguration = builder.destinationEncryptionConfiguration;
        this.timePartitioning = builder.timePartitioning;
        this.clustering = builder.clustering;
        this.jobTimeoutMs = builder.jobTimeoutMs;
        this.labels = builder.labels;
        this.rangePartitioning = builder.rangePartitioning;
        this.connectionProperties = builder.connectionProperties;
        this.maxResults = builder.maxResults;
        this.requestId = builder.requestId;
    }

    public Boolean allowLargeResults() {
        return this.allowLargeResults;
    }

    public JobInfo.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    public DatasetId getDefaultDataset() {
        return this.defaultDataset;
    }

    public TableId getDestinationTable() {
        return this.destinationTable;
    }

    public EncryptionConfiguration getDestinationEncryptionConfiguration() {
        return this.destinationEncryptionConfiguration;
    }

    public Boolean flattenResults() {
        return this.flattenResults;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getQuery() {
        return this.query;
    }

    public List<QueryParameterValue> getPositionalParameters() {
        return this.positionalParameters;
    }

    public Map<String, QueryParameterValue> getNamedParameters() {
        return this.namedParameters;
    }

    public Map<String, ExternalTableDefinition> getTableDefinitions() {
        return this.tableDefinitions;
    }

    public Boolean useQueryCache() {
        return this.useQueryCache;
    }

    public List<UserDefinedFunction> getUserDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    public Boolean useLegacySql() {
        return this.useLegacySql;
    }

    public Integer getMaximumBillingTier() {
        return this.maximumBillingTier;
    }

    public Long getMaximumBytesBilled() {
        return this.maximumBytesBilled;
    }

    public List<JobInfo.SchemaUpdateOption> getSchemaUpdateOptions() {
        return this.schemaUpdateOptions;
    }

    public TimePartitioning getTimePartitioning() {
        return this.timePartitioning;
    }

    public Clustering getClustering() {
        return this.clustering;
    }

    public Long getJobTimeoutMs() {
        return this.jobTimeoutMs;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public RangePartitioning getRangePartitioning() {
        return this.rangePartitioning;
    }

    public List<ConnectionProperty> getConnectionProperties() {
        return this.connectionProperties;
    }

    public Long getMaxResults() {
        return this.maxResults;
    }

    String getRequestId() {
        return this.requestId;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("query", (Object)this.query).add("positionalParameters", this.positionalParameters).add("namedParameters", this.namedParameters).add("destinationTable", (Object)this.destinationTable).add("destinationEncryptionConfiguration", (Object)this.destinationEncryptionConfiguration).add("defaultDataset", (Object)this.defaultDataset).add("allowLargeResults", (Object)this.allowLargeResults).add("flattenResults", (Object)this.flattenResults).add("priority", (Object)this.priority).add("tableDefinitions", this.tableDefinitions).add("useQueryCache", (Object)this.useQueryCache).add("userDefinedFunctions", this.userDefinedFunctions).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("dryRun", (Object)this.dryRun).add("useLegacySql", (Object)this.useLegacySql).add("maximumBillingTier", (Object)this.maximumBillingTier).add("maximumBytesBilled", (Object)this.maximumBytesBilled).add("schemaUpdateOptions", this.schemaUpdateOptions).add("timePartitioning", (Object)this.timePartitioning).add("clustering", (Object)this.clustering).add("jobTimeoutMs", (Object)this.jobTimeoutMs).add("labels", this.labels).add("rangePartitioning", (Object)this.rangePartitioning).add("connectionProperties", this.connectionProperties);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof QueryJobConfiguration && this.baseEquals((QueryJobConfiguration)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseHashCode(), this.allowLargeResults, this.createDisposition, this.destinationTable, this.defaultDataset, this.flattenResults, this.priority, this.query, this.positionalParameters, this.namedParameters, this.tableDefinitions, this.useQueryCache, this.userDefinedFunctions, this.writeDisposition, this.dryRun, this.useLegacySql, this.maximumBillingTier, this.maximumBytesBilled, this.schemaUpdateOptions, this.timePartitioning, this.clustering, this.jobTimeoutMs, this.labels, this.rangePartitioning, this.connectionProperties});
    }

    @Override
    QueryJobConfiguration setProjectId(String projectId) {
        Builder builder = this.toBuilder();
        if (this.getDestinationTable() != null && Strings.isNullOrEmpty((String)this.getDestinationTable().getProject())) {
            builder.setDestinationTable(this.getDestinationTable().setProjectId(projectId));
        }
        if (this.getDefaultDataset() != null) {
            builder.setDefaultDataset(this.getDefaultDataset().setProjectId(projectId));
        }
        return builder.build();
    }

    @Override
    com.google.api.services.bigquery.model.JobConfiguration toPb() {
        List queryParametersPb;
        com.google.api.services.bigquery.model.JobConfiguration configurationPb = new com.google.api.services.bigquery.model.JobConfiguration();
        JobConfigurationQuery queryConfigurationPb = new JobConfigurationQuery();
        queryConfigurationPb.setQuery(this.query);
        if (!this.positionalParameters.isEmpty()) {
            queryParametersPb = Lists.transform(this.positionalParameters, POSITIONAL_PARAMETER_TO_PB_FUNCTION);
            queryConfigurationPb.setQueryParameters(queryParametersPb);
        } else if (!this.namedParameters.isEmpty()) {
            queryParametersPb = Lists.transform((List)this.namedParameters.entrySet().asList(), NAMED_PARAMETER_TO_PB_FUNCTION);
            queryConfigurationPb.setQueryParameters(queryParametersPb);
        }
        configurationPb.setDryRun(this.dryRun());
        if (this.allowLargeResults != null) {
            queryConfigurationPb.setAllowLargeResults(this.allowLargeResults);
        }
        if (this.createDisposition != null) {
            queryConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.destinationTable != null) {
            queryConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        }
        if (this.defaultDataset != null) {
            queryConfigurationPb.setDefaultDataset(this.defaultDataset.toPb());
        }
        if (this.flattenResults != null) {
            queryConfigurationPb.setFlattenResults(this.flattenResults);
        }
        if (this.priority != null) {
            queryConfigurationPb.setPriority(this.priority.toString());
        }
        if (this.tableDefinitions != null) {
            queryConfigurationPb.setTableDefinitions(Maps.transformValues(this.tableDefinitions, ExternalTableDefinition.TO_EXTERNAL_DATA_FUNCTION));
        }
        if (this.useQueryCache != null) {
            queryConfigurationPb.setUseQueryCache(this.useQueryCache);
        }
        if (this.userDefinedFunctions != null) {
            queryConfigurationPb.setUserDefinedFunctionResources(Lists.transform(this.userDefinedFunctions, UserDefinedFunction.TO_PB_FUNCTION));
        }
        if (this.writeDisposition != null) {
            queryConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        if (this.useLegacySql != null) {
            queryConfigurationPb.setUseLegacySql(this.useLegacySql);
        }
        if (this.maximumBillingTier != null) {
            queryConfigurationPb.setMaximumBillingTier(this.maximumBillingTier);
        }
        if (this.maximumBytesBilled != null) {
            queryConfigurationPb.setMaximumBytesBilled(this.maximumBytesBilled);
        }
        if (this.schemaUpdateOptions != null) {
            ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
            for (JobInfo.SchemaUpdateOption schemaUpdateOption : this.schemaUpdateOptions) {
                schemaUpdateOptionsBuilder.add((Object)schemaUpdateOption.name());
            }
            queryConfigurationPb.setSchemaUpdateOptions((List)schemaUpdateOptionsBuilder.build());
        }
        if (this.destinationEncryptionConfiguration != null) {
            queryConfigurationPb.setDestinationEncryptionConfiguration(this.destinationEncryptionConfiguration.toPb());
        }
        if (this.timePartitioning != null) {
            queryConfigurationPb.setTimePartitioning(this.timePartitioning.toPb());
        }
        if (this.clustering != null) {
            queryConfigurationPb.setClustering(this.clustering.toPb());
        }
        if (this.jobTimeoutMs != null) {
            configurationPb.setJobTimeoutMs(this.jobTimeoutMs);
        }
        if (this.labels != null) {
            configurationPb.setLabels(this.labels);
        }
        if (this.rangePartitioning != null) {
            queryConfigurationPb.setRangePartitioning(this.rangePartitioning.toPb());
        }
        if (this.connectionProperties != null) {
            queryConfigurationPb.setConnectionProperties(Lists.transform(this.connectionProperties, ConnectionProperty.TO_PB_FUNCTION));
        }
        configurationPb.setQuery(queryConfigurationPb);
        return configurationPb;
    }

    public static Builder newBuilder(String query) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)query) ? 1 : 0) != 0, (Object)"Provided query is null or empty");
        return new Builder().setQuery(query).setRequestId(UUID.randomUUID().toString());
    }

    public static QueryJobConfiguration of(String query) {
        return QueryJobConfiguration.newBuilder(query).build();
    }

    static QueryJobConfiguration fromPb(com.google.api.services.bigquery.model.JobConfiguration jobPb) {
        return new Builder(jobPb).build();
    }

    public static final class Builder
    extends JobConfiguration.Builder<QueryJobConfiguration, Builder> {
        private String query;
        private List<QueryParameterValue> positionalParameters = Lists.newArrayList();
        private Map<String, QueryParameterValue> namedParameters = Maps.newHashMap();
        private TableId destinationTable;
        private Map<String, ExternalTableDefinition> tableDefinitions;
        private List<UserDefinedFunction> userDefinedFunctions;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private DatasetId defaultDataset;
        private Priority priority;
        private Boolean allowLargeResults;
        private Boolean useQueryCache;
        private Boolean flattenResults;
        private Boolean dryRun;
        private Boolean useLegacySql = false;
        private Integer maximumBillingTier;
        private Long maximumBytesBilled;
        private List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
        private EncryptionConfiguration destinationEncryptionConfiguration;
        private TimePartitioning timePartitioning;
        private Clustering clustering;
        private Long jobTimeoutMs;
        private Map<String, String> labels;
        private RangePartitioning rangePartitioning;
        private List<ConnectionProperty> connectionProperties;
        private Long maxResults;
        private String requestId;

        private Builder() {
            super(JobConfiguration.Type.QUERY);
        }

        private Builder(QueryJobConfiguration jobConfiguration) {
            this();
            this.query = jobConfiguration.query;
            this.namedParameters = jobConfiguration.namedParameters;
            this.positionalParameters = jobConfiguration.positionalParameters;
            this.destinationTable = jobConfiguration.destinationTable;
            this.tableDefinitions = jobConfiguration.tableDefinitions;
            this.userDefinedFunctions = jobConfiguration.userDefinedFunctions;
            this.createDisposition = jobConfiguration.createDisposition;
            this.writeDisposition = jobConfiguration.writeDisposition;
            this.defaultDataset = jobConfiguration.defaultDataset;
            this.priority = jobConfiguration.priority;
            this.allowLargeResults = jobConfiguration.allowLargeResults;
            this.useQueryCache = jobConfiguration.useQueryCache;
            this.flattenResults = jobConfiguration.flattenResults;
            this.dryRun = jobConfiguration.dryRun;
            this.useLegacySql = jobConfiguration.useLegacySql;
            this.maximumBillingTier = jobConfiguration.maximumBillingTier;
            this.maximumBytesBilled = jobConfiguration.maximumBytesBilled;
            this.schemaUpdateOptions = jobConfiguration.schemaUpdateOptions;
            this.destinationEncryptionConfiguration = jobConfiguration.destinationEncryptionConfiguration;
            this.timePartitioning = jobConfiguration.timePartitioning;
            this.clustering = jobConfiguration.clustering;
            this.jobTimeoutMs = jobConfiguration.jobTimeoutMs;
            this.labels = jobConfiguration.labels;
            this.rangePartitioning = jobConfiguration.rangePartitioning;
            this.connectionProperties = jobConfiguration.connectionProperties;
            this.maxResults = jobConfiguration.maxResults;
            this.requestId = jobConfiguration.requestId;
        }

        private Builder(com.google.api.services.bigquery.model.JobConfiguration configurationPb) {
            this();
            JobConfigurationQuery queryConfigurationPb = configurationPb.getQuery();
            this.query = queryConfigurationPb.getQuery();
            if (queryConfigurationPb.getQueryParameters() != null && !queryConfigurationPb.getQueryParameters().isEmpty()) {
                if (((QueryParameter)queryConfigurationPb.getQueryParameters().get(0)).getName() == null) {
                    this.setPositionalParameters(Lists.transform((List)queryConfigurationPb.getQueryParameters(), (Function)POSITIONAL_PARAMETER_FROM_PB_FUNCTION));
                } else {
                    HashMap values = Maps.newHashMap();
                    for (QueryParameter queryParameterPb : queryConfigurationPb.getQueryParameters()) {
                        Preconditions.checkNotNull((Object)queryParameterPb.getName());
                        QueryParameterValue value = QueryParameterValue.fromPb(queryParameterPb.getParameterValue(), queryParameterPb.getParameterType());
                        values.put(queryParameterPb.getName(), value);
                    }
                    this.setNamedParameters(values);
                }
            }
            this.allowLargeResults = queryConfigurationPb.getAllowLargeResults();
            this.useQueryCache = queryConfigurationPb.getUseQueryCache();
            this.flattenResults = queryConfigurationPb.getFlattenResults();
            this.useLegacySql = queryConfigurationPb.getUseLegacySql();
            if (queryConfigurationPb.getMaximumBillingTier() != null) {
                this.maximumBillingTier = queryConfigurationPb.getMaximumBillingTier();
            }
            if (queryConfigurationPb.getMaximumBytesBilled() != null) {
                this.maximumBytesBilled = queryConfigurationPb.getMaximumBytesBilled();
            }
            this.dryRun = configurationPb.getDryRun();
            if (queryConfigurationPb.getDestinationTable() != null) {
                this.destinationTable = TableId.fromPb(queryConfigurationPb.getDestinationTable());
            }
            if (queryConfigurationPb.getDefaultDataset() != null) {
                this.defaultDataset = DatasetId.fromPb(queryConfigurationPb.getDefaultDataset());
            }
            if (queryConfigurationPb.getPriority() != null) {
                this.priority = Priority.valueOf(queryConfigurationPb.getPriority());
            }
            if (queryConfigurationPb.getTableDefinitions() != null) {
                this.tableDefinitions = Maps.transformValues((Map)queryConfigurationPb.getTableDefinitions(), ExternalTableDefinition.FROM_EXTERNAL_DATA_FUNCTION);
            }
            if (queryConfigurationPb.getUserDefinedFunctionResources() != null) {
                this.userDefinedFunctions = Lists.transform((List)queryConfigurationPb.getUserDefinedFunctionResources(), UserDefinedFunction.FROM_PB_FUNCTION);
            }
            if (queryConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(queryConfigurationPb.getCreateDisposition());
            }
            if (queryConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(queryConfigurationPb.getWriteDisposition());
            }
            if (queryConfigurationPb.getSchemaUpdateOptions() != null) {
                ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
                for (String rawSchemaUpdateOption : queryConfigurationPb.getSchemaUpdateOptions()) {
                    schemaUpdateOptionsBuilder.add((Object)JobInfo.SchemaUpdateOption.valueOf(rawSchemaUpdateOption));
                }
                this.schemaUpdateOptions = schemaUpdateOptionsBuilder.build();
            }
            if (queryConfigurationPb.getDestinationEncryptionConfiguration() != null) {
                this.destinationEncryptionConfiguration = new EncryptionConfiguration.Builder(queryConfigurationPb.getDestinationEncryptionConfiguration()).build();
            }
            if (queryConfigurationPb.getTimePartitioning() != null) {
                this.timePartitioning = TimePartitioning.fromPb(queryConfigurationPb.getTimePartitioning());
            }
            if (queryConfigurationPb.getClustering() != null) {
                this.clustering = Clustering.fromPb(queryConfigurationPb.getClustering());
            }
            if (configurationPb.getJobTimeoutMs() != null) {
                this.jobTimeoutMs = configurationPb.getJobTimeoutMs();
            }
            if (configurationPb.getLabels() != null) {
                this.labels = configurationPb.getLabels();
            }
            if (queryConfigurationPb.getRangePartitioning() != null) {
                this.rangePartitioning = RangePartitioning.fromPb(queryConfigurationPb.getRangePartitioning());
            }
            if (queryConfigurationPb.getConnectionProperties() != null) {
                this.connectionProperties = Lists.transform((List)queryConfigurationPb.getConnectionProperties(), ConnectionProperty.FROM_PB_FUNCTION);
            }
        }

        public Builder setQuery(String query) {
            this.query = query;
            return this;
        }

        public Builder addPositionalParameter(QueryParameterValue value) {
            Preconditions.checkNotNull((Object)value);
            if (!this.namedParameters.isEmpty()) {
                throw new IllegalStateException("Positional parameters can't be combined with named parameters");
            }
            this.positionalParameters.add(value);
            return this;
        }

        public Builder setPositionalParameters(Iterable<QueryParameterValue> values) {
            if (values == null || Iterables.isEmpty(values)) {
                this.positionalParameters = Lists.newArrayList();
            } else {
                if (!this.namedParameters.isEmpty()) {
                    throw new IllegalStateException("Positional parameters can't be combined with named parameters");
                }
                this.positionalParameters = Lists.newArrayList(values);
            }
            return this;
        }

        public Builder addNamedParameter(String name, QueryParameterValue value) {
            Preconditions.checkNotNull((Object)value);
            if (!this.positionalParameters.isEmpty()) {
                throw new IllegalStateException("Named parameters can't be combined with positional parameters");
            }
            this.namedParameters.put(name, value);
            return this;
        }

        public Builder setNamedParameters(Map<String, QueryParameterValue> values) {
            if (values == null || values.isEmpty()) {
                this.namedParameters = Maps.newHashMap();
            } else {
                if (!this.positionalParameters.isEmpty()) {
                    throw new IllegalStateException("Named parameters can't be combined with positional parameters");
                }
                this.namedParameters = Maps.newHashMap(values);
            }
            return this;
        }

        public Builder setDestinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        public Builder setDestinationEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.destinationEncryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public Builder setTableDefinitions(Map<String, ExternalTableDefinition> tableDefinitions) {
            this.tableDefinitions = tableDefinitions != null ? Maps.newHashMap(tableDefinitions) : null;
            return this;
        }

        public Builder addTableDefinition(String tableName, ExternalTableDefinition tableDefinition) {
            if (this.tableDefinitions == null) {
                this.tableDefinitions = Maps.newHashMap();
            }
            this.tableDefinitions.put((String)Preconditions.checkNotNull((Object)tableName), (ExternalTableDefinition)Preconditions.checkNotNull((Object)tableDefinition));
            return this;
        }

        public Builder setUserDefinedFunctions(List<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = userDefinedFunctions != null ? ImmutableList.copyOf(userDefinedFunctions) : null;
            return this;
        }

        public Builder setCreateDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        public Builder setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        public Builder setDefaultDataset(DatasetId defaultDataset) {
            this.defaultDataset = defaultDataset;
            return this;
        }

        public Builder setDefaultDataset(String defaultDataset) {
            return this.setDefaultDataset(DatasetId.of(defaultDataset));
        }

        public Builder setPriority(Priority priority) {
            this.priority = priority;
            return this;
        }

        public Builder setAllowLargeResults(Boolean allowLargeResults) {
            this.allowLargeResults = allowLargeResults;
            return this;
        }

        public Builder setUseQueryCache(Boolean useQueryCache) {
            this.useQueryCache = useQueryCache;
            return this;
        }

        public Builder setFlattenResults(Boolean flattenResults) {
            this.flattenResults = flattenResults;
            return this;
        }

        public Builder setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder setUseLegacySql(Boolean useLegacySql) {
            this.useLegacySql = useLegacySql;
            return this;
        }

        public Builder setMaximumBillingTier(Integer maximumBillingTier) {
            this.maximumBillingTier = maximumBillingTier;
            return this;
        }

        public Builder setMaximumBytesBilled(Long maximumBytesBilled) {
            this.maximumBytesBilled = maximumBytesBilled;
            return this;
        }

        public Builder setSchemaUpdateOptions(List<JobInfo.SchemaUpdateOption> schemaUpdateOptions) {
            this.schemaUpdateOptions = schemaUpdateOptions;
            return this;
        }

        public Builder setTimePartitioning(TimePartitioning timePartitioning) {
            this.timePartitioning = timePartitioning;
            return this;
        }

        public Builder setClustering(Clustering clustering) {
            this.clustering = clustering;
            return this;
        }

        public Builder setJobTimeoutMs(Long jobTimeoutMs) {
            this.jobTimeoutMs = jobTimeoutMs;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder setRangePartitioning(RangePartitioning rangePartitioning) {
            this.rangePartitioning = rangePartitioning;
            return this;
        }

        public Builder setConnectionProperties(List<ConnectionProperty> connectionProperties) {
            this.connectionProperties = ImmutableList.copyOf(connectionProperties);
            return this;
        }

        public Builder setMaxResults(Long maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public QueryJobConfiguration build() {
            return new QueryJobConfiguration(this);
        }
    }

    public static enum Priority {
        INTERACTIVE,
        BATCH;

    }
}

