/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConfiguration;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConnectionFactory;
import org.apache.camel.component.google.bigquery.GoogleBigQueryEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="google-bigquery")
public class GoogleBigQueryComponent
extends DefaultComponent {
    private String projectId;
    private String datasetId;
    private GoogleBigQueryConnectionFactory connectionFactory;

    public GoogleBigQueryComponent() {
    }

    public GoogleBigQueryComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] parts = remaining.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Google BigQuery Endpoint format \"projectId:datasetId:tableName\"");
        }
        GoogleBigQueryConfiguration configuration = new GoogleBigQueryConfiguration();
        configuration.parseRemaining(remaining);
        if (configuration.getConnectionFactory() == null) {
            configuration.setConnectionFactory(this.getConnectionFactory());
        }
        GoogleBigQueryEndpoint endpoint = new GoogleBigQueryEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public GoogleBigQueryConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new GoogleBigQueryConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(GoogleBigQueryConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

