/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.github.transformers;

import java.util.Map;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;
import org.eclipse.egit.github.core.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTypeTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String FIELD_KEY_CONFIG = "key";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("key", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Transforms an Event Type to String");
    private static final Logger LOG = LoggerFactory.getLogger(EventTypeTransforms.class);

    public R apply(R r) {
        Object value = r.value();
        if (value instanceof Event) {
            LOG.debug("Converting record from Event Type to text");
            Event message = (Event)r.value();
            LOG.debug("Received text: {}", (Object)message.getType());
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), null, r.key(), (Schema)SchemaHelper.buildSchemaBuilderForType((Object)message.getType()), (Object)message.getType(), r.timestamp());
        }
        LOG.debug("Unexpected message type: {}", r.value().getClass());
        return r;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }
}

