/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.github.GitHubComponent;
import org.apache.camel.component.github.GitHubType;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.component.github.consumer.CommitConsumer;
import org.apache.camel.component.github.consumer.EventsConsumer;
import org.apache.camel.component.github.consumer.PullRequestCommentConsumer;
import org.apache.camel.component.github.consumer.PullRequestConsumer;
import org.apache.camel.component.github.consumer.TagConsumer;
import org.apache.camel.component.github.event.GitHubEventFetchStrategy;
import org.apache.camel.component.github.producer.ClosePullRequestProducer;
import org.apache.camel.component.github.producer.CreateIssueProducer;
import org.apache.camel.component.github.producer.GetCommitFileProducer;
import org.apache.camel.component.github.producer.PullRequestCommentProducer;
import org.apache.camel.component.github.producer.PullRequestFilesProducer;
import org.apache.camel.component.github.producer.PullRequestStateProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@UriEndpoint(firstVersion="2.15.0", scheme="github", title="GitHub", syntax="github:type/branchName", category={Category.FILE, Category.CLOUD, Category.API})
public class GitHubEndpoint
extends ScheduledPollEndpoint {
    @UriPath
    @Metadata(required=true)
    private GitHubType type;
    @UriPath(label="consumer")
    private String branchName;
    @UriParam(label="security", secret=true)
    private String oauthToken;
    @UriParam
    @Metadata(required=true)
    private String repoOwner;
    @UriParam
    @Metadata(required=true)
    private String repoName;
    @UriParam(label="producer", enums="error,failure,pending,success")
    private String state;
    @UriParam(label="producer")
    private String targetUrl;
    @UriParam(label="producer")
    private String encoding;
    @UriParam(label="consumer,advanced")
    private GitHubEventFetchStrategy eventFetchStrategy;

    public GitHubEndpoint(String uri, GitHubComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        if (this.type == GitHubType.CLOSEPULLREQUEST) {
            return new ClosePullRequestProducer(this);
        }
        if (this.type == GitHubType.PULLREQUESTCOMMENT) {
            return new PullRequestCommentProducer(this);
        }
        if (this.type == GitHubType.PULLREQUESTSTATE) {
            return new PullRequestStateProducer(this);
        }
        if (this.type == GitHubType.PULLREQUESTFILES) {
            return new PullRequestFilesProducer(this);
        }
        if (this.type == GitHubType.GETCOMMITFILE) {
            return new GetCommitFileProducer(this);
        }
        if (this.type == GitHubType.CREATEISSUE) {
            return new CreateIssueProducer(this);
        }
        throw new IllegalArgumentException("Cannot create producer with type " + (Object)((Object)this.type));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        AbstractGitHubConsumer consumer = null;
        if (this.type == GitHubType.COMMIT) {
            StringHelper.notEmpty((String)this.branchName, (String)"branchName", (Object)((Object)this));
            consumer = new CommitConsumer(this, processor, this.branchName);
        } else if (this.type == GitHubType.PULLREQUEST) {
            consumer = new PullRequestConsumer(this, processor);
        } else if (this.type == GitHubType.PULLREQUESTCOMMENT) {
            consumer = new PullRequestCommentConsumer(this, processor);
        } else if (this.type == GitHubType.TAG) {
            consumer = new TagConsumer(this, processor);
        } else if (this.type == GitHubType.EVENT) {
            consumer = new EventsConsumer(this, processor);
        }
        if (consumer == null) {
            throw new IllegalArgumentException("Cannot create consumer with type " + (Object)((Object)this.type));
        }
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public GitHubType getType() {
        return this.type;
    }

    public void setType(GitHubType type) {
        this.type = type;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public void setRepoOwner(String repoOwner) {
        this.repoOwner = repoOwner;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public GitHubEventFetchStrategy getEventFetchStrategy() {
        return this.eventFetchStrategy;
    }

    public void setEventFetchStrategy(GitHubEventFetchStrategy eventFetchStrategy) {
        this.eventFetchStrategy = eventFetchStrategy;
    }

    protected void doInit() throws Exception {
        super.doInit();
        ObjectHelper.notNull((Object)this.oauthToken, (String)"oauthToken");
    }
}

