/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.producer;

import java.util.Calendar;
import org.apache.camel.Exchange;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.producer.AbstractGitHubProducer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.PullRequestService;

public class ClosePullRequestProducer
extends AbstractGitHubProducer {
    private PullRequestService pullRequestService;

    public ClosePullRequestProducer(GitHubEndpoint endpoint) throws Exception {
        super(endpoint);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubPullRequestService");
        this.pullRequestService = service != null ? (PullRequestService)service : new PullRequestService();
        this.initService((GitHubService)this.pullRequestService);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Integer pullRequestNumber = (Integer)exchange.getIn().getHeader("GitHubPullRequest", Integer.class);
        PullRequest pullRequest = this.pullRequestService.getPullRequest((IRepositoryIdProvider)this.getRepository(), pullRequestNumber.intValue());
        pullRequest.setState("closed");
        pullRequest.setClosedAt(Calendar.getInstance().getTime());
        pullRequest = this.pullRequestService.editPullRequest((IRepositoryIdProvider)this.getRepository(), pullRequest);
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody((Object)pullRequest);
        }
    }
}

