/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryContents;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.service.GitHubService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentsService
extends GitHubService {
    public ContentsService() {
    }

    public ContentsService(GitHubClient client) {
        super(client);
    }

    public RepositoryContents getReadme(IRepositoryIdProvider repository) throws Exception {
        return this.getReadme(repository, null);
    }

    public RepositoryContents getReadme(IRepositoryIdProvider repository, String ref) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/readme");
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        if (ref != null && ref.length() > 0) {
            request.setParams(Collections.singletonMap("ref", ref));
        }
        request.setType((Type)((Object)RepositoryContents.class));
        return (RepositoryContents)this.client.get(request).getBody();
    }

    public List<RepositoryContents> getContents(IRepositoryIdProvider repository) throws IOException {
        return this.getContents(repository, null);
    }

    public List<RepositoryContents> getContents(IRepositoryIdProvider repository, String path) throws IOException {
        return this.getContents(repository, path, null);
    }

    public List<RepositoryContents> getContents(IRepositoryIdProvider repository, String path, String ref) throws IOException {
        Object body;
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/contents");
        if (path != null && path.length() > 0) {
            if (path.charAt(0) != '/') {
                uri.append('/');
            }
            uri.append(path);
        }
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)RepositoryContents.class));
        request.setArrayType(new TypeToken<List<RepositoryContents>>(){}.getType());
        if (ref != null && ref.length() > 0) {
            request.setParams(Collections.singletonMap("ref", ref));
        }
        if ((body = this.client.get(request).getBody()) instanceof RepositoryContents) {
            return Collections.singletonList((RepositoryContents)body);
        }
        return (List)body;
    }
}

