/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ScheduledPollConsumer;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitHubConsumer
extends ScheduledPollConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(AbstractGitHubConsumer.class);
    private final GitHubEndpoint endpoint;
    private RepositoryService repositoryService;
    private Repository repository;

    public AbstractGitHubConsumer(GitHubEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubRepositoryService");
        if (service != null) {
            LOG.debug("Using RepositoryService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.repositoryService = (RepositoryService)service;
        } else {
            this.repositoryService = new RepositoryService();
        }
        this.initService((GitHubService)this.repositoryService);
        this.repository = this.repositoryService.getRepository(endpoint.getRepoOwner(), endpoint.getRepoName());
    }

    protected void initService(GitHubService service) {
        service.getClient().setOAuth2Token(this.endpoint.getOauthToken());
    }

    protected RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected abstract int poll() throws Exception;
}

