/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;

public class NumericExpression
extends BaseSimpleNode {
    private final Object number;

    public NumericExpression(SimpleToken token, String text) {
        super(token);
        long lon;
        boolean dot;
        boolean bl = dot = text.indexOf(46) != -1;
        this.number = dot ? (Number)Double.parseDouble(text) : (Number)((lon = Long.parseLong(text)) < Integer.MAX_VALUE ? (Number)Integer.valueOf(text) : (Number)lon);
    }

    public Object getNumber() {
        return this.number;
    }

    @Override
    public Expression createExpression(CamelContext camelContext, String expression) throws SimpleParserException {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                if (type == Object.class || type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == Double.TYPE || type == Double.class) {
                    return type.cast(NumericExpression.this.number);
                }
                return (T)exchange.getContext().getTypeConverter().tryConvertTo(type, exchange, NumericExpression.this.number);
            }

            public String toString() {
                return "" + NumericExpression.this.number;
            }
        };
    }

    @Override
    public String createCode(String expression) throws SimpleParserException {
        if (this.number instanceof Double) {
            return this.number + "d";
        }
        if (this.number instanceof Long) {
            return this.number + "l";
        }
        return this.number.toString();
    }
}

