/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.model.rest.RestSecuritiesDefinition;
import org.apache.camel.model.rest.RestSecurityDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="rest,security")
@XmlRootElement(name="oauth2")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestSecurityOAuth2
extends RestSecurityDefinition {
    @XmlAttribute
    private String authorizationUrl;
    @XmlAttribute
    private String tokenUrl;
    @XmlAttribute
    private String refreshUrl;
    @XmlAttribute
    @Metadata(enums="implicit,password,application,clientCredentials,accessCode,authorizationCode")
    private String flow;
    @XmlElement(name="scopes")
    private List<RestPropertyDefinition> scopes = new ArrayList<RestPropertyDefinition>();

    public RestSecurityOAuth2() {
    }

    public RestSecurityOAuth2(RestDefinition rest) {
        super(rest);
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public void setRefreshUrl(String refreshUrl) {
        this.refreshUrl = refreshUrl;
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public List<RestPropertyDefinition> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<RestPropertyDefinition> scopes) {
        this.scopes = scopes;
    }

    public RestSecurityOAuth2 flow(String flow) {
        this.setFlow(flow);
        return this;
    }

    public RestSecurityOAuth2 authorizationUrl(String authorizationUrl) {
        this.setAuthorizationUrl(authorizationUrl);
        return this;
    }

    public RestSecurityOAuth2 tokenUrl(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        return this;
    }

    public RestSecurityOAuth2 refreshUrl(String refreshUrl) {
        this.setRefreshUrl(refreshUrl);
        return this;
    }

    public RestSecurityOAuth2 password(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setFlow("password");
        return this;
    }

    public RestSecurityOAuth2 application(String tokenUrl) {
        return this.clientCredentials(tokenUrl);
    }

    public RestSecurityOAuth2 clientCredentials(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        this.setFlow("clientCredentials");
        return this;
    }

    public RestSecurityOAuth2 accessCode(String authorizationUrl, String tokenUrl) {
        return this.authorizationCode(authorizationUrl, tokenUrl);
    }

    public RestSecurityOAuth2 authorizationCode(String authorizationUrl, String tokenUrl) {
        this.setAuthorizationUrl(authorizationUrl);
        this.setTokenUrl(tokenUrl);
        this.setFlow("authorizationCode");
        return this;
    }

    public RestSecurityOAuth2 withScope(String key, String description) {
        this.scopes.add(new RestPropertyDefinition(key, description));
        return this;
    }

    public RestSecuritiesDefinition end() {
        return this.rest.getSecurityDefinitions();
    }
}

