/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.support.LocalBeanRegistry;

@XmlTransient
public final class DefaultRouteTemplateContext
implements RouteTemplateContext {
    private final CamelContext camelContext;
    private final LocalBeanRegistry registry;
    private final Map<String, Object> parameters;
    private Consumer<RouteTemplateContext> configurer;

    public DefaultRouteTemplateContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.registry = new LocalBeanRegistry();
        this.parameters = new HashMap<String, Object>();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void bind(String id, Object bean) {
        if (bean instanceof RouteTemplateContext.BeanSupplier) {
            RouteTemplateContext.BeanSupplier bs = (RouteTemplateContext.BeanSupplier)bean;
            this.registry.bind(id, () -> bs.get((RouteTemplateContext)this));
        } else {
            this.registry.bind(id, bean);
        }
    }

    public void bind(String id, Class<?> type, Object bean) {
        if (bean instanceof RouteTemplateContext.BeanSupplier) {
            RouteTemplateContext.BeanSupplier bs = (RouteTemplateContext.BeanSupplier)bean;
            this.registry.bind(id, type, () -> bs.get((RouteTemplateContext)this));
        } else {
            this.registry.bind(id, type, bean);
        }
    }

    public void bind(String id, Class<?> type, Supplier<Object> bean) {
        this.registry.bind(id, type, bean);
    }

    public void bindAsPrototype(String id, Class<?> type, Supplier<Object> bean) {
        this.registry.bindAsPrototype(id, type, bean);
    }

    public Object getProperty(String name) {
        return this.parameters.get(name);
    }

    public <T> T getProperty(String name, Class<?> type) {
        Object value = this.parameters.get(name);
        return (T)this.camelContext.getTypeConverter().tryConvertTo(type, value);
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public BeanRepository getLocalBeanRepository() {
        return this.registry;
    }

    public Consumer<RouteTemplateContext> getConfigurer() {
        return this.configurer;
    }

    public void setConfigurer(Consumer<RouteTemplateContext> configurer) {
        this.configurer = configurer;
    }
}

