/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Route;
import org.apache.camel.Traceable;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.cache.EmptyProducerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingSlip
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingSlip.class);
    protected String id;
    protected String routeId;
    protected ProducerCache producerCache;
    protected int cacheSize;
    protected boolean ignoreInvalidEndpoints;
    protected String header;
    protected Expression expression;
    protected String uriDelimiter;
    protected final CamelContext camelContext;
    protected AsyncProcessor errorHandler;

    public RoutingSlip(CamelContext camelContext) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        this.camelContext = camelContext;
    }

    public RoutingSlip(CamelContext camelContext, Expression expression, String uriDelimiter) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        ObjectHelper.notNull((Object)expression, (String)"expression");
        this.camelContext = camelContext;
        this.expression = expression;
        this.uriDelimiter = uriDelimiter;
        this.header = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setDelimiter(String delimiter) {
        this.uriDelimiter = delimiter;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public AsyncProcessor getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(AsyncProcessor errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "routingSlip[" + this.expression + "]";
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException((Throwable)new IllegalStateException("RoutingSlip has not been started: " + (Object)((Object)this)));
            callback.done(true);
            return true;
        }
        Expression exp = this.expression;
        Object slip = exchange.removeProperty(ExchangePropertyKey.EVALUATE_EXPRESSION_RESULT);
        if (slip != null) {
            exp = slip instanceof Expression ? (Expression)slip : ExpressionBuilder.constantExpression((Object)slip);
        }
        return this.doRoutingSlipWithExpression(exchange, exp, callback);
    }

    protected RoutingSlipIterator createRoutingSlipIterator(Exchange exchange, Expression expression) throws Exception {
        Object slip = expression.evaluate(exchange, Object.class);
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        final Iterator delegate = org.apache.camel.support.ObjectHelper.createIterator((Object)slip, (String)this.uriDelimiter);
        return new RoutingSlipIterator(){

            @Override
            public boolean hasNext(Exchange exchange) {
                return delegate.hasNext();
            }

            @Override
            public Object next(Exchange exchange) {
                return delegate.next();
            }
        };
    }

    private boolean doRoutingSlipWithExpression(Exchange exchange, Expression expression, AsyncCallback originalCallback) {
        RoutingSlipIterator iter;
        Exchange current = exchange;
        try {
            iter = this.createRoutingSlipIterator(exchange, expression);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            originalCallback.done(true);
            return true;
        }
        current.removeProperty(ExchangePropertyKey.SLIP_ENDPOINT);
        while (iter.hasNext(current)) {
            FailedToCreateProducerException e;
            Endpoint endpoint;
            boolean prototype = this.cacheSize < 0;
            try {
                Object recipient = iter.next(exchange);
                recipient = RoutingSlip.prepareRecipient(exchange, recipient);
                Endpoint existing = RoutingSlip.getExistingEndpoint(exchange, recipient);
                if (existing == null) {
                    endpoint = this.resolveEndpoint(exchange, recipient, prototype);
                } else {
                    endpoint = existing;
                    prototype = false;
                }
                if (endpoint == null) {
                    continue;
                }
            }
            catch (Exception e2) {
                current.setException((Throwable)e2);
                break;
            }
            boolean sync = this.processExchange(endpoint, current, exchange, originalCallback, iter, prototype);
            current = this.prepareExchangeForRoutingSlip(current, endpoint);
            if (!sync) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
            }
            if (this.isIgnoreInvalidEndpoints() && (e = (FailedToCreateProducerException)current.getException(FailedToCreateProducerException.class)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored.", (Throwable)e);
                }
                current.setException(null);
            }
            if (PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", LOG)) continue;
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)current);
        }
        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)current);
        originalCallback.done(true);
        return true;
    }

    protected static Object prepareRecipient(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof Endpoint || recipient instanceof NormalizedEndpointUri) {
            return recipient;
        }
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        if (recipient != null) {
            ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext();
            String uri = recipient instanceof String ? (String)recipient : (String)ecc.getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
            return ecc.normalizeUri(uri);
        }
        return null;
    }

    protected static Endpoint getExistingEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof Endpoint) {
            return (Endpoint)recipient;
        }
        if (recipient != null) {
            if (recipient instanceof NormalizedEndpointUri) {
                NormalizedEndpointUri nu = (NormalizedEndpointUri)recipient;
                ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext();
                return ecc.hasEndpoint(nu);
            }
            String uri = recipient.toString();
            return exchange.getContext().hasEndpoint(uri);
        }
        return null;
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient, boolean prototype) throws Exception {
        Endpoint endpoint = null;
        try {
            endpoint = prototype ? ExchangeHelper.resolvePrototypeEndpoint((Exchange)exchange, (Object)recipient) : ExchangeHelper.resolveEndpoint((Exchange)exchange, (Object)recipient);
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidEndpoints()) {
                LOG.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", (Throwable)e);
            }
            throw e;
        }
        return endpoint;
    }

    protected Exchange prepareExchangeForRoutingSlip(Exchange current, Endpoint endpoint) {
        Exchange copy = ExchangeHelper.createCopy((Exchange)current, (boolean)true);
        ExchangeHelper.prepareOutToIn((Exchange)copy);
        MessageHelper.resetStreamCache((Message)copy.getIn());
        return copy;
    }

    protected AsyncProcessor createErrorHandler(Route route, Exchange exchange, AsyncProcessor processor, Endpoint endpoint) {
        AsyncProcessor answer = processor;
        boolean tryBlock = (Boolean)exchange.getProperty(ExchangePropertyKey.TRY_ROUTE_BLOCK, Boolean.TYPE);
        if (!tryBlock && route != null && this.errorHandler != null) {
            answer = this.errorHandler;
        }
        return answer;
    }

    protected boolean processExchange(final Endpoint endpoint, final Exchange exchange, final Exchange original, AsyncCallback originalCallback, final RoutingSlipIterator iter, final boolean prototype) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        AsyncCallback callback = doneSync -> {
            if (!doneSync) {
                originalCallback.done(false);
            }
        };
        return this.producerCache.doInAsyncProducer(endpoint, exchange, callback, (p, ex, cb) -> {
            Route route = ExchangeHelper.getRoute((Exchange)ex);
            AsyncProcessor target = this.createErrorHandler(route, ex, (AsyncProcessor)p, endpoint);
            ex.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)endpoint.getEndpointUri());
            ex.setProperty(ExchangePropertyKey.SLIP_ENDPOINT, (Object)endpoint.getEndpointUri());
            ex.setProperty(ExchangePropertyKey.SLIP_PRODUCER, (Object)p);
            return target.process(ex, new AsyncCallback(){

                public void done(boolean doneSync) {
                    ex.removeProperty(ExchangePropertyKey.SLIP_PRODUCER);
                    if (doneSync) {
                        if (prototype) {
                            ServiceHelper.stopAndShutdownService((Object)endpoint);
                        }
                        cb.done(true);
                        return;
                    }
                    try {
                        Exchange current = RoutingSlip.this.prepareExchangeForRoutingSlip(ex, endpoint);
                        while (iter.hasNext(current)) {
                            Endpoint nextEndpoint;
                            FailedToCreateProducerException e;
                            if (RoutingSlip.this.isIgnoreInvalidEndpoints() && (e = (FailedToCreateProducerException)current.getException(FailedToCreateProducerException.class)) != null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored.", (Throwable)e);
                                }
                                current.setException(null);
                            }
                            if (!PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", LOG)) break;
                            boolean prototype2 = RoutingSlip.this.cacheSize < 0;
                            try {
                                Object recipient = iter.next(ex);
                                recipient = RoutingSlip.prepareRecipient(exchange, recipient);
                                Endpoint existing = RoutingSlip.getExistingEndpoint(exchange, recipient);
                                if (existing == null) {
                                    nextEndpoint = RoutingSlip.this.resolveEndpoint(exchange, recipient, prototype2);
                                } else {
                                    nextEndpoint = existing;
                                    prototype2 = false;
                                }
                                if (nextEndpoint == null) {
                                    continue;
                                }
                            }
                            catch (Exception e2) {
                                current.setException((Throwable)e2);
                                break;
                            }
                            boolean prototypeEndpoint = prototype2;
                            AsyncCallback cbNext = doneNext -> {
                                if (prototypeEndpoint) {
                                    ServiceHelper.stopAndShutdownService((Object)nextEndpoint);
                                }
                                cb.done(doneNext);
                            };
                            boolean sync = RoutingSlip.this.processExchange(nextEndpoint, current, original, cbNext, iter, prototype2);
                            current = RoutingSlip.this.prepareExchangeForRoutingSlip(current, nextEndpoint);
                            if (sync) continue;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)original.getExchangeId());
                            }
                            return;
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)original.getExchangeId(), (Object)current);
                        }
                        ExchangeHelper.copyResults((Exchange)original, (Exchange)current);
                    }
                    catch (Throwable e) {
                        ex.setException(e);
                    }
                    cb.done(false);
                }
            });
        });
    }

    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache((Object)this, this.camelContext);
                LOG.debug("RoutingSlip {} is not using ProducerCache", (Object)this);
            } else {
                this.producerCache = new DefaultProducerCache((Object)this, this.camelContext, this.cacheSize);
                LOG.debug("RoutingSlip {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startService((Object[])new Object[]{this.producerCache, this.errorHandler});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.producerCache, this.errorHandler});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.producerCache, this.errorHandler});
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    private Message getResultMessage(Exchange exchange) {
        return exchange.getMessage();
    }

    public AsyncProcessor newRoutingSlipProcessorForErrorHandler() {
        return new RoutingSlipProcessor();
    }

    private final class RoutingSlipProcessor
    extends AsyncProcessorSupport {
        private RoutingSlipProcessor() {
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            AsyncProcessor producer = (AsyncProcessor)exchange.getProperty(ExchangePropertyKey.SLIP_PRODUCER, AsyncProcessor.class);
            return producer.process(exchange, callback);
        }

        public String toString() {
            return "RoutingSlipProcessor";
        }
    }

    protected static interface RoutingSlipIterator {
        public boolean hasNext(Exchange var1);

        public Object next(Exchange var1);
    }
}

