/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.RouteContext;

public class RoutingSlipReifier
extends ExpressionReifier<RoutingSlipDefinition<?>> {
    public RoutingSlipReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (RoutingSlipDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Expression expression = this.createExpression(((RoutingSlipDefinition)this.definition).getExpression());
        String delimiter = this.parseString(((RoutingSlipDefinition)this.definition).getUriDelimiter());
        if (delimiter == null) {
            delimiter = ",";
        }
        RoutingSlip routingSlip = new RoutingSlip(this.camelContext, expression, delimiter);
        if (((RoutingSlipDefinition)this.definition).getIgnoreInvalidEndpoints() != null) {
            routingSlip.setIgnoreInvalidEndpoints(this.parseBoolean(((RoutingSlipDefinition)this.definition).getIgnoreInvalidEndpoints(), false));
        }
        if (((RoutingSlipDefinition)this.definition).getCacheSize() != null) {
            routingSlip.setCacheSize(this.parseInt(((RoutingSlipDefinition)this.definition).getCacheSize()).intValue());
        }
        ErrorHandlerFactory builder = this.routeContext.getErrorHandlerFactory();
        AsyncProcessor errorHandler = (AsyncProcessor)ErrorHandlerReifier.reifier(this.routeContext, builder).createErrorHandler((Processor)routingSlip.newRoutingSlipProcessorForErrorHandler());
        routingSlip.setErrorHandler(errorHandler);
        return routingSlip;
    }
}

