/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.git;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelGitSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_GIT_PATH_LOCAL_PATH_CONF = "camel.sink.path.localPath";
    public static final String CAMEL_SINK_GIT_PATH_LOCAL_PATH_DOC = "Local repository path";
    public static final String CAMEL_SINK_GIT_PATH_LOCAL_PATH_DEFAULT = null;
    public static final String CAMEL_SINK_GIT_ENDPOINT_BRANCH_NAME_CONF = "camel.sink.endpoint.branchName";
    public static final String CAMEL_SINK_GIT_ENDPOINT_BRANCH_NAME_DOC = "The branch name to work on";
    public static final String CAMEL_SINK_GIT_ENDPOINT_BRANCH_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_GIT_ENDPOINT_ALLOW_EMPTY_CONF = "camel.sink.endpoint.allowEmpty";
    public static final String CAMEL_SINK_GIT_ENDPOINT_ALLOW_EMPTY_DOC = "The flag to manage empty git commits";
    public static final Boolean CAMEL_SINK_GIT_ENDPOINT_ALLOW_EMPTY_DEFAULT = true;
    public static final String CAMEL_SINK_GIT_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_GIT_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_GIT_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_GIT_ENDPOINT_OPERATION_CONF = "camel.sink.endpoint.operation";
    public static final String CAMEL_SINK_GIT_ENDPOINT_OPERATION_DOC = "The operation to do on the repository One of: [clone] [init] [add] [remove] [commit] [commitAll] [createBranch] [deleteBranch] [createTag] [deleteTag] [status] [log] [push] [pull] [showBranches] [cherryPick] [remoteAdd] [remoteList]";
    public static final String CAMEL_SINK_GIT_ENDPOINT_OPERATION_DEFAULT = null;
    public static final String CAMEL_SINK_GIT_ENDPOINT_PASSWORD_CONF = "camel.sink.endpoint.password";
    public static final String CAMEL_SINK_GIT_ENDPOINT_PASSWORD_DOC = "Remote repository password";
    public static final String CAMEL_SINK_GIT_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_GIT_ENDPOINT_REMOTE_NAME_CONF = "camel.sink.endpoint.remoteName";
    public static final String CAMEL_SINK_GIT_ENDPOINT_REMOTE_NAME_DOC = "The remote repository name to use in particular operation like pull";
    public static final String CAMEL_SINK_GIT_ENDPOINT_REMOTE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_GIT_ENDPOINT_REMOTE_PATH_CONF = "camel.sink.endpoint.remotePath";
    public static final String CAMEL_SINK_GIT_ENDPOINT_REMOTE_PATH_DOC = "The remote repository path";
    public static final String CAMEL_SINK_GIT_ENDPOINT_REMOTE_PATH_DEFAULT = null;
    public static final String CAMEL_SINK_GIT_ENDPOINT_TAG_NAME_CONF = "camel.sink.endpoint.tagName";
    public static final String CAMEL_SINK_GIT_ENDPOINT_TAG_NAME_DOC = "The tag name to work on";
    public static final String CAMEL_SINK_GIT_ENDPOINT_TAG_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_GIT_ENDPOINT_USERNAME_CONF = "camel.sink.endpoint.username";
    public static final String CAMEL_SINK_GIT_ENDPOINT_USERNAME_DOC = "Remote repository username";
    public static final String CAMEL_SINK_GIT_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_GIT_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.git.lazyStartProducer";
    public static final String CAMEL_SINK_GIT_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_GIT_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_GIT_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.git.autowiredEnabled";
    public static final String CAMEL_SINK_GIT_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_GIT_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelGitSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelGitSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_GIT_PATH_LOCAL_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GIT_PATH_LOCAL_PATH_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_GIT_PATH_LOCAL_PATH_DOC);
        conf.define(CAMEL_SINK_GIT_ENDPOINT_BRANCH_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GIT_ENDPOINT_BRANCH_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_ENDPOINT_BRANCH_NAME_DOC);
        conf.define(CAMEL_SINK_GIT_ENDPOINT_ALLOW_EMPTY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_GIT_ENDPOINT_ALLOW_EMPTY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_ENDPOINT_ALLOW_EMPTY_DOC);
        conf.define(CAMEL_SINK_GIT_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_GIT_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_GIT_ENDPOINT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GIT_ENDPOINT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_ENDPOINT_OPERATION_DOC);
        conf.define(CAMEL_SINK_GIT_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GIT_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_GIT_ENDPOINT_REMOTE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GIT_ENDPOINT_REMOTE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_ENDPOINT_REMOTE_NAME_DOC);
        conf.define(CAMEL_SINK_GIT_ENDPOINT_REMOTE_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GIT_ENDPOINT_REMOTE_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_ENDPOINT_REMOTE_PATH_DOC);
        conf.define(CAMEL_SINK_GIT_ENDPOINT_TAG_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GIT_ENDPOINT_TAG_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_ENDPOINT_TAG_NAME_DOC);
        conf.define(CAMEL_SINK_GIT_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_GIT_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SINK_GIT_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_GIT_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_GIT_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_GIT_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_GIT_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}