/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Arrays;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptSendToEndpointProcessor
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptSendToEndpointProcessor.class);
    private final InterceptSendToEndpoint endpoint;
    private final Endpoint delegate;
    private final AsyncProducer producer;
    private final boolean skip;
    private AsyncProcessor pipeline;

    public InterceptSendToEndpointProcessor(InterceptSendToEndpoint endpoint, Endpoint delegate, AsyncProducer producer, boolean skip) {
        super(delegate);
        this.endpoint = endpoint;
        this.delegate = delegate;
        this.producer = producer;
        this.skip = skip;
    }

    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending to endpoint: {} is intercepted and detoured to: {} for exchange: {}", new Object[]{this.getEndpoint(), this.endpoint.getBefore(), exchange});
        }
        exchange.setProperty(ExchangePropertyKey.INTERCEPTED_ENDPOINT, (Object)this.delegate.getEndpointUri());
        if (this.pipeline != null) {
            return this.pipeline.process(exchange, callback);
        }
        return this.callback(exchange, callback, true);
    }

    private boolean callback(Exchange exchange, AsyncCallback callback, boolean doneSync) {
        if (!PipelineHelper.continueProcessing(exchange, "skip sending to original intended destination: " + String.valueOf(this.getEndpoint()), LOG)) {
            callback.done(doneSync);
            return doneSync;
        }
        boolean shouldSkip = this.skip;
        Boolean whenMatches = this.endpoint.getAfter() != null ? (Boolean)exchange.getProperty(ExchangePropertyKey.INTERCEPT_SEND_TO_ENDPOINT_WHEN_MATCHED) : (Boolean)exchange.removeProperty(ExchangePropertyKey.INTERCEPT_SEND_TO_ENDPOINT_WHEN_MATCHED);
        if (whenMatches != null) {
            boolean bl = shouldSkip = this.skip && whenMatches != false;
        }
        if (!shouldSkip) {
            ExchangeHelper.prepareOutToIn((Exchange)exchange);
            boolean s = this.producer.process(exchange, ds -> callback.done(doneSync && ds));
            return doneSync && s;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stop() means skip sending exchange to original intended destination: {} for exchange: {}", (Object)this.getEndpoint(), (Object)exchange);
        }
        callback.done(doneSync);
        return doneSync;
    }

    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    protected void doBuild() throws Exception {
        CamelContextAware.trySetCamelContext((Object)this.producer, (CamelContext)this.endpoint.getCamelContext());
        if (this.endpoint.getBefore() != null || this.endpoint.getAfter() != null) {
            AsyncProcessor before = null;
            if (this.endpoint.getBefore() != null) {
                before = AsyncProcessorConverterHelper.convert((Processor)this.endpoint.getBefore());
            }
            AsyncProcessorSupport ascb = new AsyncProcessorSupport(){

                public boolean process(Exchange exchange, AsyncCallback callback) {
                    return InterceptSendToEndpointProcessor.this.callback(exchange, callback, true);
                }
            };
            FilterProcessor filter = this.createFilterProcessor();
            this.pipeline = new Pipeline(this.getEndpoint().getCamelContext(), Arrays.asList(new Processor[]{before, ascb, filter}));
        }
        ServiceHelper.buildService((Object[])new Object[]{this.producer, this.pipeline});
    }

    private FilterProcessor createFilterProcessor() {
        Predicate predicate = exchange -> {
            Boolean whenMatches = (Boolean)exchange.removeProperty(ExchangePropertyKey.INTERCEPT_SEND_TO_ENDPOINT_WHEN_MATCHED);
            return whenMatches == null || whenMatches != false;
        };
        AsyncProcessor after = null;
        if (this.endpoint.getAfter() != null) {
            after = AsyncProcessorConverterHelper.convert((Processor)this.endpoint.getAfter());
        }
        return new FilterProcessor(this.getEndpoint().getCamelContext(), predicate, (Processor)after);
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object[])new Object[]{this.producer, this.pipeline});
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.producer, this.pipeline});
    }

    public void doStop() {
        ServiceHelper.stopService((Service)this.producer);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.producer, this.pipeline});
    }
}

