/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetVariableDefinition;
import org.apache.camel.model.SetVariablesDefinition;
import org.apache.camel.processor.SetVariablesProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.support.LanguageSupport;

public class SetVariablesReifier
extends ProcessorReifier<SetVariablesDefinition> {
    public SetVariablesReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (SetVariablesDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        if (((SetVariablesDefinition)this.definition).getVariables().isEmpty()) {
            throw new IllegalArgumentException("There must be at least one variable specified");
        }
        ArrayList<Expression> nameExprs = new ArrayList<Expression>(((SetVariablesDefinition)this.definition).getVariables().size());
        ArrayList<Expression> valueExprs = new ArrayList<Expression>(((SetVariablesDefinition)this.definition).getVariables().size());
        for (SetVariableDefinition varDef : ((SetVariablesDefinition)this.definition).getVariables()) {
            valueExprs.add(this.createExpression(varDef.getExpression()));
            String key = this.parseString(varDef.getName());
            Expression nameExpr = LanguageSupport.hasSimpleFunction((String)key) ? this.camelContext.resolveLanguage("simple").createExpression(key) : this.camelContext.resolveLanguage("constant").createExpression(key);
            nameExpr.init(this.camelContext);
            nameExprs.add(nameExpr);
        }
        return new SetVariablesProcessor(nameExprs, valueExprs);
    }
}

