/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.LogProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.processor.DefaultMaskingFormatter;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReifier
extends ProcessorReifier<LogDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(LogReifier.class);

    public LogReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (LogDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        StringHelper.notEmpty((String)((LogDefinition)this.definition).getMessage(), (String)"message", (Object)this);
        String msg = this.parseString(((LogDefinition)this.definition).getMessage());
        String lan = this.parseString(((LogDefinition)this.definition).getLogLanguage());
        if (lan == null) {
            lan = this.camelContext.getGlobalOption("CamelLogEipLanguage");
        }
        Expression exp = null;
        if (lan == null && LanguageSupport.hasSimpleFunction((String)msg)) {
            exp = this.camelContext.resolveLanguage("simple").createExpression(msg);
        } else if (lan != null) {
            exp = this.camelContext.resolveLanguage(lan).createExpression(msg);
        }
        Logger logger = ((LogDefinition)this.definition).getLoggerBean();
        if (logger == null && ObjectHelper.isNotEmpty((String)((LogDefinition)this.definition).getLogger())) {
            logger = this.mandatoryLookup(((LogDefinition)this.definition).getLogger(), Logger.class);
        }
        if (logger == null) {
            logger = (Logger)this.findSingleByType(Logger.class);
        }
        if (logger == null) {
            String name = this.parseString(((LogDefinition)this.definition).getLogName());
            if (name == null && (name = this.camelContext.getGlobalOption("CamelLogEipName")) != null) {
                LOG.debug("Using logName from CamelContext global option: {}", (Object)name);
            }
            if (name != null) {
                name = StringHelper.replaceFirst((String)name, (String)"${class}", (String)LogProcessor.class.getName());
                name = StringHelper.replaceFirst((String)name, (String)"${contextId}", (String)this.camelContext.getName());
                name = StringHelper.replaceFirst((String)name, (String)"${routeId}", (String)this.route.getRouteId());
                name = StringHelper.replaceFirst((String)name, (String)"${groupId}", (String)this.route.getGroup());
                name = StringHelper.replaceFirst((String)name, (String)"${nodeId}", (String)((LogDefinition)this.definition).getId());
                name = StringHelper.replaceFirst((String)name, (String)"${nodePrefixId}", (String)((LogDefinition)this.definition).getNodePrefixId());
                if (this.camelContext.isSourceLocationEnabled().booleanValue()) {
                    String source = LoggerHelper.getLineNumberLoggerName((Object)this.definition);
                    name = StringHelper.replaceFirst((String)name, (String)"${source}", (String)source);
                    name = StringHelper.replaceFirst((String)name, (String)"${source.name}", (String)StringHelper.before((String)source, (String)":", (String)source));
                    name = StringHelper.replaceFirst((String)name, (String)"${source.line}", (String)StringHelper.after((String)source, (String)":", (String)""));
                }
            }
            if (name == null) {
                if (this.camelContext.isSourceLocationEnabled().booleanValue() && (name = LoggerHelper.getLineNumberLoggerName((Object)this.definition)) != null) {
                    LOG.debug("LogName is not configured, using source location as logName: {}", (Object)name);
                }
                if (name == null) {
                    name = this.route.getRouteId();
                    LOG.debug("LogName is not configured, using route id as logName: {}", (Object)name);
                }
            }
            logger = LoggerFactory.getLogger((String)name);
        }
        LoggingLevel level = ((LogDefinition)this.definition).getLoggingLevel() != null ? this.parse(LoggingLevel.class, ((LogDefinition)this.definition).getLoggingLevel()) : LoggingLevel.INFO;
        CamelLogger camelLogger = new CamelLogger(logger, level, ((LogDefinition)this.definition).getMarker());
        if (exp != null) {
            return new LogProcessor(exp, camelLogger, this.getMaskingFormatter(), this.camelContext.getCamelContextExtension().getLogListeners());
        }
        return new LogProcessor(msg, camelLogger, this.getMaskingFormatter(), this.camelContext.getCamelContextExtension().getLogListeners());
    }

    private MaskingFormatter getMaskingFormatter() {
        if (this.route.isLogMask().booleanValue()) {
            MaskingFormatter formatter = this.lookupByNameAndType("CamelCustomLogMask", MaskingFormatter.class);
            if (formatter == null) {
                formatter = new DefaultMaskingFormatter();
            }
            return formatter;
        }
        return null;
    }
}

