/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.SftpRemoteFile;
import org.apache.camel.component.file.remote.SftpRemoteFileSingle;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.function.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpConsumer
extends RemoteFileConsumer<SftpRemoteFile> {
    private static final Logger LOG = LoggerFactory.getLogger(SftpConsumer.class);
    private String endpointPath;
    private transient String sftpConsumerToString;

    public SftpConsumer(RemoteFileEndpoint<SftpRemoteFile> endpoint, Processor processor, RemoteFileOperations<SftpRemoteFile> operations, GenericFileProcessStrategy<SftpRemoteFile> processStrategy) {
        super(endpoint, processor, operations, processStrategy);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        boolean startScheduler = this.isStartScheduler();
        this.setStartScheduler(false);
        try {
            super.doStart();
            if (this.endpoint.isAutoCreate() && this.hasStartingDirectory()) {
                String dir = this.endpoint.getConfiguration().getDirectory();
                LOG.debug("Auto creating directory: {}", (Object)dir);
                try {
                    this.connectIfNecessary();
                    this.operations.buildDirectory(dir, true);
                }
                catch (GenericFileOperationFailedException e) {
                    LOG.warn("Error auto creating directory: " + dir + " due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                }
            }
        }
        finally {
            if (startScheduler) {
                this.setStartScheduler(true);
                this.startScheduler();
            }
        }
    }

    protected boolean pollDirectory(String fileName, List<GenericFile<SftpRemoteFile>> fileList, int depth) {
        String currentDir = null;
        if (this.isStepwise()) {
            currentDir = this.operations.getCurrentDirectory();
        }
        fileName = FileUtil.stripTrailingSeparator((String)fileName);
        boolean answer = this.doPollDirectory(fileName, (String)null, fileList, depth);
        if (currentDir != null) {
            this.operations.changeCurrentDirectory(currentDir);
        }
        return answer;
    }

    protected boolean pollSubDirectory(String absolutePath, String dirName, List<GenericFile<SftpRemoteFile>> fileList, int depth) {
        boolean answer = this.doSafePollSubDirectory(absolutePath, dirName, fileList, depth);
        if (this.isStepwise()) {
            this.operations.changeToParentDirectory();
        }
        return answer;
    }

    @Override
    protected boolean doPollDirectory(String absolutePath, String dirName, List<GenericFile<SftpRemoteFile>> fileList, int depth) {
        String dir;
        LOG.trace("doPollDirectory from absolutePath: {}, dirName: {}", (Object)absolutePath, (Object)dirName);
        ++depth;
        dirName = FileUtil.stripTrailingSeparator((String)dirName);
        if (this.isStepwise()) {
            dir = ObjectHelper.isNotEmpty((String)dirName) ? dirName : absolutePath;
            this.operations.changeCurrentDirectory(dir);
        } else {
            dir = absolutePath;
        }
        Object[] files = this.getSftpRemoteFiles(dir);
        if (files == null || files.length == 0) {
            LOG.trace("No files found in directory: {}", (Object)dir);
            return true;
        }
        LOG.trace("Found {} files in directory: {}", (Object)files.length, (Object)dir);
        if (this.getEndpoint().isPreSort()) {
            Arrays.sort(files, Comparator.comparing(SftpRemoteFile::getFilename));
        }
        for (SftpRemoteFile sftpRemoteFile : files) {
            Supplier<String> relativePath;
            Supplier remote;
            String absoluteFilePath;
            if (LOG.isTraceEnabled()) {
                LOG.trace("SftpFile[fileName={}, longName={}, dir={}]", new Object[]{sftpRemoteFile.getFilename(), sftpRemoteFile.getLongname(), sftpRemoteFile.isDirectory()});
            }
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (sftpRemoteFile.isDirectory()) {
                if (!this.endpoint.isRecursive() || depth >= this.endpoint.getMaxDepth()) continue;
                absoluteFilePath = FtpUtils.absoluteFilePath(absolutePath, sftpRemoteFile.getFilename());
                remote = Suppliers.memorize(() -> this.asRemoteFile(absolutePath, absoluteFilePath, file, this.getEndpoint().getCharset()));
                relativePath = this.getRelativeFilePath(this.endpointPath, null, absolutePath, sftpRemoteFile);
                if (!this.isValidFile(remote, sftpRemoteFile.getFilename(), absoluteFilePath, relativePath, true, files)) continue;
                String subDirectory = sftpRemoteFile.getFilename();
                Object path = ObjectHelper.isNotEmpty((String)absolutePath) ? absolutePath + "/" + subDirectory : subDirectory;
                boolean canPollMore = this.pollSubDirectory((String)path, subDirectory, fileList, depth);
                if (canPollMore) continue;
                return false;
            }
            if (depth < this.endpoint.getMinDepth()) continue;
            absoluteFilePath = FtpUtils.absoluteFilePath(absolutePath, sftpRemoteFile.getFilename());
            remote = Suppliers.memorize(() -> this.asRemoteFile(absolutePath, absoluteFilePath, file, this.getEndpoint().getCharset()));
            relativePath = this.getRelativeFilePath(this.endpointPath, null, absolutePath, sftpRemoteFile);
            if (!this.isValidFile(remote, sftpRemoteFile.getFilename(), absoluteFilePath, relativePath, false, files)) continue;
            fileList.add((GenericFile<SftpRemoteFile>)((GenericFile)remote.get()));
        }
        return true;
    }

    private SftpRemoteFile[] listFiles(String dir) {
        if (this.isStepwise()) {
            return (SftpRemoteFile[])this.operations.listFiles();
        }
        return (SftpRemoteFile[])this.operations.listFiles(dir);
    }

    private SftpRemoteFile[] getSftpRemoteFiles(String dir) {
        SftpRemoteFile[] files = null;
        try {
            LOG.trace("Polling directory: {}", (Object)dir);
            files = this.isUseList() ? this.listFiles(dir) : this.pollNamedFile();
        }
        catch (GenericFileOperationFailedException e) {
            if (this.ignoreCannotRetrieveFile(null, null, (Exception)((Object)e))) {
                LOG.debug("Cannot list files in directory {} due directory does not exist or file permission error.", (Object)dir);
            }
            throw e;
        }
        return files;
    }

    private SftpRemoteFile[] pollNamedFile() {
        SftpRemoteFile[] files = null;
        Exchange dummy = ExchangeHelper.getDummy((CamelContext)this.getEndpoint().getCamelContext());
        String name = this.evaluateFileExpression(dummy);
        if (name != null) {
            SftpRemoteFileSingle file = new SftpRemoteFileSingle(name);
            files = new SftpRemoteFile[]{file};
        }
        return files;
    }

    protected boolean isMatched(Supplier<GenericFile<SftpRemoteFile>> file, String doneFileName, SftpRemoteFile[] files) {
        String onlyName = FileUtil.stripPath((String)doneFileName);
        for (SftpRemoteFile f : files) {
            if (!f.getFilename().equals(onlyName)) continue;
            return true;
        }
        LOG.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    protected boolean ignoreCannotRetrieveFile(String name, Exchange exchange, Exception cause) {
        SftpException sftp;
        if (this.getEndpoint().getConfiguration().isIgnoreFileNotFoundOrPermissionError() && (sftp = (SftpException)ObjectHelper.getException(SftpException.class, (Throwable)cause)) != null) {
            return sftp.id == 2 || sftp.id == 3;
        }
        return super.ignoreCannotRetrieveFile(name, exchange, cause);
    }

    protected Supplier<String> getRelativeFilePath(String endpointPath, String path, String absolutePath, SftpRemoteFile file) {
        return () -> {
            String relativePath = StringHelper.after((String)absolutePath, (String)endpointPath);
            return FileUtil.stripLeadingSeparator((String)relativePath) + "/" + file.getFilename();
        };
    }

    private RemoteFile<SftpRemoteFile> asRemoteFile(String absolutePath, String absoluteFilePath, SftpRemoteFile file, String charset) {
        RemoteFile<SftpRemoteFile> answer = new RemoteFile<SftpRemoteFile>();
        answer.setCharset(charset);
        answer.setEndpointPath(this.endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getFilename());
        answer.setFileLength(file.getFileLength());
        answer.setLastModified(file.getLastModified());
        answer.setHostname(((RemoteFileConfiguration)this.endpoint.getConfiguration()).getHost());
        answer.setDirectory(file.isDirectory());
        boolean absolute = FileUtil.hasLeadingSeparator((String)absolutePath);
        answer.setAbsolute(absolute);
        answer.setAbsoluteFilePath(absoluteFilePath);
        String relativePath = StringHelper.after((String)absoluteFilePath, (String)this.endpointPath);
        relativePath = FileUtil.stripLeadingSeparator((String)relativePath);
        answer.setRelativeFilePath(relativePath);
        answer.setFileName(answer.getRelativeFilePath());
        return answer;
    }

    protected void updateFileHeaders(GenericFile<SftpRemoteFile> file, Message message) {
        Object rf = ((SftpRemoteFile)file.getFile()).getRemoteFile();
        if (rf != null) {
            ChannelSftp.LsEntry e = (ChannelSftp.LsEntry)rf;
            long length = e.getAttrs().getSize();
            long modified = (long)e.getAttrs().getMTime() * 1000L;
            file.setFileLength(length);
            file.setLastModified(modified);
            if (length >= 0L) {
                message.setHeader("CamelFileLength", (Object)length);
            }
            if (modified >= 0L) {
                message.setHeader("CamelFileLastModified", (Object)modified);
            }
        }
    }

    private boolean isStepwise() {
        RemoteFileConfiguration config = (RemoteFileConfiguration)this.endpoint.getConfiguration();
        return config.isStepwise();
    }

    private boolean isUseList() {
        RemoteFileConfiguration config = (RemoteFileConfiguration)this.endpoint.getConfiguration();
        return config.isUseList();
    }

    public String toString() {
        if (this.sftpConsumerToString == null) {
            this.sftpConsumerToString = "SftpConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sftpConsumerToString;
    }
}

