/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.JSch;
import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.component.file.remote.SftpRemoteFile;
import org.apache.camel.util.StringHelper;

@org.apache.camel.spi.annotations.Component(value="sftp")
@ManagedResource(description="Managed SFTP Component")
public class SftpComponent
extends RemoteFileComponent<SftpRemoteFile> {
    public SftpComponent() {
    }

    public SftpComponent(CamelContext context) {
        super(context);
    }

    protected GenericFileEndpoint<SftpRemoteFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = StringHelper.before((String)uri, (String)"?", (String)uri);
        SftpConfiguration config = new SftpConfiguration(new URI(baseUri));
        FtpUtils.ensureRelativeFtpDirectory((Component)this, config);
        return new SftpEndpoint(uri, this, config);
    }

    protected void afterPropertiesSet(GenericFileEndpoint<SftpRemoteFile> endpoint) throws Exception {
    }

    @ManagedOperation(description="Dump JSCH Configuration")
    public String dumpConfiguration() {
        StringBuilder sb = new StringBuilder();
        TreeMap map = new TreeMap(String::compareToIgnoreCase);
        map.putAll(JSch.getConfig());
        for (Map.Entry e : map.entrySet()) {
            String v = e.getValue() != null ? (String)e.getValue() : "";
            sb.append(String.format("%s = %s%n", e.getKey(), v));
        }
        return sb.toString();
    }
}

