/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AbstractListAggregationStrategy;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultExchange;

@Metadata(label="bean", description="Aggregate all Exchanges into a single combined Exchange holding all the aggregated exchanges in a List of Exchange as the message body. This aggregation strategy can be used in combination with Splitter to batch messages.", annotations={"interfaceName=org.apache.camel.AggregationStrategy"})
@Configurer(metadataOnly=true)
public class GroupedExchangeAggregationStrategy
extends AbstractListAggregationStrategy<Exchange> {
    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            oldExchange = new DefaultExchange(newExchange);
        }
        return super.aggregate(oldExchange, newExchange);
    }

    @Override
    public Exchange getValue(Exchange exchange) {
        return exchange;
    }
}

