/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.DependencyStrategy;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@ManagedResource(description="Managed Kamelet RoutesBuilderLoader")
@RoutesLoader(value="kamelet.yaml")
public class KameletRoutesBuilderLoader
extends YamlRoutesBuilderLoaderSupport {
    public static final String EXTENSION = "kamelet.yaml";

    public KameletRoutesBuilderLoader() {
        super(EXTENSION);
    }

    @Override
    protected RouteBuilder builder(YamlDeserializationContext ctx, Node root) {
        YamlDeserializerSupport.setDeserializationContext((Node)root, (YamlDeserializationContext)ctx);
        Node template = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/template");
        if (template == null) {
            throw new IllegalArgumentException("No template defined");
        }
        Set required = YamlDeserializerSupport.asStringSet((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/definition/required"));
        if (required == null) {
            required = Collections.emptySet();
        }
        final RouteTemplateDefinition rtd = (RouteTemplateDefinition)ctx.construct(template, RouteTemplateDefinition.class);
        rtd.id(YamlDeserializerSupport.asText((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/metadata/name")));
        Node properties = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/definition/properties");
        if (properties != null) {
            rtd.setTemplateParameters(new ArrayList());
            for (NodeTuple p : YamlDeserializerSupport.asMappingNode((Node)properties).getValue()) {
                String key = YamlDeserializerSupport.asText((Node)p.getKeyNode());
                Node def = YamlDeserializerSupport.nodeAt((Node)p.getValueNode(), (String)"/default");
                RouteTemplateParameterDefinition rtpd = new RouteTemplateParameterDefinition();
                rtpd.setName(key);
                rtpd.setDefaultValue(YamlDeserializerSupport.asText((Node)def));
                rtpd.setRequired(Boolean.valueOf(required.contains(key)));
                rtd.getTemplateParameters().add(rtpd);
            }
        }
        Node deps = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/dependencies");
        CamelContextCustomizer customizer = null;
        if (deps != null) {
            customizer = this.preConfigureDependencies(deps);
        }
        final CamelContextCustomizer dependencies = customizer;
        return new RouteBuilder(){

            public void configure() throws Exception {
                if (dependencies != null) {
                    dependencies.configure(this.getCamelContext());
                }
                this.getRouteTemplateCollection().routeTemplate(rtd);
            }
        };
    }

    private CamelContextCustomizer preConfigureDependencies(Node node) {
        final List dep = YamlDeserializerSupport.asStringList((Node)node);
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                for (DependencyStrategy ds : camelContext.getRegistry().findByType(DependencyStrategy.class)) {
                    for (String d : dep) {
                        try {
                            ds.onDependency(d);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        };
    }
}

