/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.io;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Pattern;

public class XMLWriter {
    private static final Pattern LOWERS = Pattern.compile("([\u0000-\u001f])");
    private final Writer writer;
    private final String lineIndenter;
    private final String lineSeparator;
    private final String encoding;
    private final String docType;
    private final Deque<String> elements = new ArrayDeque<String>();
    private boolean tagInProgress;
    private int depth;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;

    public XMLWriter(Writer writer) throws IOException {
        this(writer, null, null);
    }

    public XMLWriter(Writer writer, String lineIndenter) throws IOException {
        this(writer, lineIndenter, null, null);
    }

    public XMLWriter(Writer writer, String encoding, String doctype) throws IOException {
        this(writer, null, encoding, doctype);
    }

    public XMLWriter(Writer writer, String lineIndenter, String encoding, String doctype) throws IOException {
        this(writer, lineIndenter, null, encoding, doctype);
    }

    public XMLWriter(Writer writer, String lineIndenter, String lineSeparator, String encoding, String doctype) throws IOException {
        this.writer = writer;
        this.lineIndenter = lineIndenter != null ? lineIndenter : "    ";
        this.lineSeparator = XMLWriter.validateLineSeparator(lineSeparator);
        this.encoding = encoding;
        this.docType = doctype;
        if (doctype != null || encoding != null) {
            this.writeDocumentHeaders();
        }
    }

    private static String validateLineSeparator(String lineSeparator) {
        String ls;
        String string = ls = lineSeparator != null ? lineSeparator : System.lineSeparator();
        if (!(ls.equals("\n") || ls.equals("\r") || ls.equals("\r\n"))) {
            throw new IllegalArgumentException("Requested line separator is invalid.");
        }
        return ls;
    }

    public void startElement(String name) throws IOException {
        this.tagIsEmpty = false;
        this.finishTag();
        this.write("<");
        this.write(name);
        this.elements.addLast(name);
        this.tagInProgress = true;
        ++this.depth;
        this.readyForNewLine = true;
        this.tagIsEmpty = true;
    }

    public void writeText(String text) throws IOException {
        this.writeText(text, true);
    }

    public void writeMarkup(String text) throws IOException {
        this.writeText(text, false);
    }

    private void writeText(String text, boolean escapeXml) throws IOException {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        if (escapeXml) {
            text = XMLWriter.escapeXml(text);
        }
        this.write(this.unifyLineSeparators(text));
    }

    private String unifyLineSeparators(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) == '\r') {
                if (i + 1 < length && s.charAt(i + 1) == '\n') {
                    ++i;
                }
                buffer.append(this.lineSeparator);
                continue;
            }
            if (s.charAt(i) == '\n') {
                buffer.append(this.lineSeparator);
                continue;
            }
            buffer.append(s.charAt(i));
        }
        return buffer.toString();
    }

    private static String escapeXml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String escapeXmlAttribute(String text) {
        text = XMLWriter.escapeXml(text).replace("\"", "&quot;").replace("'", "&apos;");
        text = text.replace("\r\n", "&#10;");
        text = LOWERS.matcher(text).replaceAll(r -> "&#" + Integer.toString(r.group(1).charAt(0)) + ";");
        return text;
    }

    public void addAttribute(String key, String value) throws IOException {
        this.write(" ");
        this.write(key);
        this.write("=\"");
        this.write(XMLWriter.escapeXmlAttribute(value));
        this.write("\"");
    }

    public void endElement(String name) throws IOException {
        --this.depth;
        if (this.tagIsEmpty) {
            this.write("/");
            this.readyForNewLine = false;
            this.finishTag();
            this.elements.removeLast();
        } else {
            this.finishTag();
            this.write("</" + this.elements.removeLast() + ">");
        }
        this.readyForNewLine = true;
    }

    private void write(String str) throws IOException {
        this.getWriter().write(str);
    }

    private void finishTag() throws IOException {
        if (this.tagInProgress) {
            this.write(">");
        }
        this.tagInProgress = false;
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    protected String getLineIndenter() {
        return this.lineIndenter;
    }

    protected String getLineSeparator() {
        return this.lineSeparator;
    }

    protected void endOfLine() throws IOException {
        this.write(this.getLineSeparator());
        for (int i = 0; i < this.getDepth(); ++i) {
            this.write(this.getLineIndenter());
        }
    }

    private void writeDocumentHeaders() throws IOException {
        this.write("<?xml version=\"1.0\"");
        if (this.getEncoding() != null) {
            this.write(" encoding=\"" + this.getEncoding() + "\"");
        }
        this.write("?>");
        this.endOfLine();
        if (this.getDocType() != null) {
            this.write("<!DOCTYPE ");
            this.write(this.getDocType());
            this.write(">");
            this.endOfLine();
        }
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public String getDocType() {
        return this.docType;
    }

    public Deque<String> getElements() {
        return this.elements;
    }
}

