/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public class IoUtil {
    private static ByteArrayOutputStream toBaos(InputStream stream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        IoUtil.copy(stream, result);
        return result;
    }

    public static void close(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void closeIgnore(AutoCloseable closeable) {
        try {
            IoUtil.close(closeable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] toBytes(InputStream stream) {
        try {
            byte[] byArray = IoUtil.toBaos(stream).toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IoUtil.close(stream);
        }
    }

    public static byte[] toBytes(InputStream stream, boolean closeStream) {
        try {
            byte[] byArray = IoUtil.toBaos(stream).toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (closeStream) {
                IoUtil.close(stream);
            }
        }
    }

    public static String toString(InputStream stream) {
        try {
            String string = IoUtil.toBaos(stream).toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            IoUtil.close(stream);
        }
    }

    public static String toString(byte[] bytes) {
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(String string) {
        return string == null ? null : string.getBytes(StandardCharsets.UTF_8);
    }

    public static InputStream toStream(String content) {
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    public static InputStream toStream(byte[] content) {
        return new ByteArrayInputStream(content);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        long count = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

