/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.HashMap;
import java.util.Map;

@RegisterForReflection
public enum LogLevel {
    DEBUG("DEBUG"),
    TRACE("TRACE"),
    WARN("WARN"),
    ERROR("ERROR"),
    SEVERE("SEVERE"),
    WARNING("WARNING"),
    INFO("INFO"),
    CONFIG("CONFIG"),
    FINE("FINE"),
    FINER("FINER"),
    FINEST("FINEST");

    private final String value;
    private static final Map<String, LogLevel> CONSTANTS;

    private LogLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static LogLevel fromValue(String value) {
        LogLevel constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, LogLevel>();
        for (LogLevel c : LogLevel.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

