/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.FailFastAssertionException;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.Keyword;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.i18n.MessageSource;
import com.networknt.schema.utils.StringUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class ValidationMessageHandler {
    protected final MessageSource messageSource;
    protected ErrorMessageType errorMessageType;
    protected SchemaLocation schemaLocation;
    protected JsonNodePath evaluationPath;
    protected JsonSchema evaluationParentSchema;
    protected JsonSchema parentSchema;
    protected boolean customErrorMessagesEnabled;
    protected Map<String, String> errorMessage;
    protected Keyword keyword;

    protected ValidationMessageHandler(ErrorMessageType errorMessageType, boolean customErrorMessagesEnabled, MessageSource messageSource, Keyword keyword, JsonSchema parentSchema, SchemaLocation schemaLocation, JsonNodePath evaluationPath) {
        this.errorMessageType = errorMessageType;
        this.messageSource = messageSource;
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
        this.evaluationPath = Objects.requireNonNull(evaluationPath);
        this.parentSchema = parentSchema;
        this.customErrorMessagesEnabled = customErrorMessagesEnabled;
        this.updateKeyword(keyword);
    }

    protected ValidationMessageHandler(ValidationMessageHandler copy) {
        this.messageSource = copy.messageSource;
        this.errorMessageType = copy.errorMessageType;
        this.schemaLocation = copy.schemaLocation;
        this.evaluationPath = copy.evaluationPath;
        this.parentSchema = copy.parentSchema;
        this.evaluationParentSchema = copy.evaluationParentSchema;
        this.customErrorMessagesEnabled = copy.customErrorMessagesEnabled;
        this.errorMessage = copy.errorMessage;
        this.keyword = copy.keyword;
    }

    protected MessageSourceValidationMessage.Builder message() {
        return (MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)MessageSourceValidationMessage.builder(this.messageSource, this.errorMessage, (message, failFast) -> {
            if (failFast.booleanValue()) {
                throw new FailFastAssertionException((ValidationMessage)message);
            }
        }).code(this.getErrorMessageType().getErrorCode())).schemaLocation(this.schemaLocation)).evaluationPath(this.evaluationPath)).type(this.keyword != null ? this.keyword.getValue() : null)).messageKey(this.getErrorMessageType().getErrorCodeValue());
    }

    protected ErrorMessageType getErrorMessageType() {
        return this.errorMessageType;
    }

    protected void parseErrorCode(String errorCodeKey) {
        String errorCodeText;
        JsonNode errorCodeNode;
        if (errorCodeKey != null && this.parentSchema != null && (errorCodeNode = this.parentSchema.getSchemaNode().get(errorCodeKey)) != null && errorCodeNode.isTextual() && StringUtils.isNotBlank(errorCodeText = errorCodeNode.asText())) {
            this.errorMessageType = CustomErrorMessageType.of(errorCodeText);
        }
    }

    protected void updateValidatorType(ValidatorTypeCode validatorTypeCode) {
        this.updateKeyword(validatorTypeCode);
        this.updateErrorMessageType(validatorTypeCode);
    }

    protected void updateErrorMessageType(ErrorMessageType errorMessageType) {
        this.errorMessageType = errorMessageType;
    }

    protected void updateKeyword(Keyword keyword) {
        this.keyword = keyword;
        if (this.keyword != null) {
            if (this.customErrorMessagesEnabled && keyword != null && this.parentSchema != null) {
                this.errorMessage = this.getErrorMessage(this.parentSchema.getSchemaNode(), keyword.getValue());
            }
            this.parseErrorCode(this.getErrorCodeKey(keyword.getValue()));
        }
    }

    protected Map<String, String> getErrorMessage(JsonNode schemaNode, String keyword) {
        JsonNode messageNode;
        JsonSchema parentSchema = this.parentSchema;
        JsonNode message = this.getMessageNode(schemaNode, parentSchema, keyword);
        if (message != null && (messageNode = message.get(keyword)) != null) {
            if (messageNode.isTextual()) {
                return Collections.singletonMap("", messageNode.asText());
            }
            if (messageNode.isObject()) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                messageNode.fields().forEachRemaining(entry -> result.put((String)entry.getKey(), ((JsonNode)entry.getValue()).textValue()));
                if (!result.isEmpty()) {
                    return result;
                }
            }
        }
        return Collections.emptyMap();
    }

    protected JsonNode getMessageNode(JsonNode schemaNode, JsonSchema parentSchema, String pname) {
        if (schemaNode.get("message") != null && schemaNode.get("message").get(pname) != null) {
            return schemaNode.get("message");
        }
        JsonNode messageNode = schemaNode.get("message");
        if (messageNode == null && parentSchema != null && (messageNode = parentSchema.schemaNode.get("message")) == null) {
            return this.getMessageNode(parentSchema.schemaNode, parentSchema.getParentSchema(), pname);
        }
        return messageNode;
    }

    protected String getErrorCodeKey(String keyword) {
        if (keyword != null) {
            return keyword + "ErrorCode";
        }
        return null;
    }
}

