/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.Traceable;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.ErrorHandlerAware;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.InternalProcessorFactory;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.AsyncCompletionService;
import org.apache.camel.util.concurrent.Rejectable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MulticastProcessor
extends AsyncProcessorSupport
implements Navigate<Processor>,
Traceable,
IdAware,
RouteIdAware,
ErrorHandlerAware {
    private static final Logger LOG = LoggerFactory.getLogger(MulticastProcessor.class);
    protected final Processor onPrepare;
    protected final ProcessorExchangeFactory processorExchangeFactory;
    private final Lock lock = new ReentrantLock();
    private final AsyncProcessorAwaitManager awaitManager;
    private final CamelContext camelContext;
    private final InternalProcessorFactory internalProcessorFactory;
    private final Route route;
    private final ReactiveExecutor reactiveExecutor;
    private Processor errorHandler;
    private String id;
    private String routeId;
    private final Collection<Processor> processors;
    private final AggregationStrategy aggregationStrategy;
    private final boolean parallelProcessing;
    private boolean synchronous;
    private final boolean streaming;
    private final boolean parallelAggregate;
    private final boolean stopOnException;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private final Scheduler scheduler = new Scheduler();
    private final SyncScheduler syncScheduler = new SyncScheduler();
    private ExecutorService aggregateExecutorService;
    private boolean shutdownAggregateExecutorService;
    private final long timeout;
    private final int cacheSize;
    private final ConcurrentMap<Processor, Processor> errorHandlers;
    private final boolean shareUnitOfWork;

    public MulticastProcessor(CamelContext camelContext, Route route, Collection<Processor> processors) {
        this(camelContext, route, processors, null);
    }

    public MulticastProcessor(CamelContext camelContext, Route route, Collection<Processor> processors, AggregationStrategy aggregationStrategy) {
        this(camelContext, route, processors, aggregationStrategy, false, null, false, false, false, 0L, null, false, false, CamelContextHelper.getMaximumCachePoolSize((CamelContext)camelContext));
    }

    public MulticastProcessor(CamelContext camelContext, Route route, Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean shareUnitOfWork, boolean parallelAggregate, int cacheSize) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        this.camelContext = camelContext;
        this.internalProcessorFactory = PluginHelper.getInternalProcessorFactory((CamelContext)camelContext);
        this.awaitManager = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)camelContext);
        this.route = route;
        this.reactiveExecutor = camelContext.getCamelContextExtension().getReactiveExecutor();
        this.processors = processors;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.streaming = streaming;
        this.stopOnException = stopOnException;
        this.parallelProcessing = parallelProcessing || executorService != null;
        this.timeout = timeout;
        this.onPrepare = onPrepare;
        this.shareUnitOfWork = shareUnitOfWork;
        this.parallelAggregate = parallelAggregate;
        this.processorExchangeFactory = camelContext.getCamelContextExtension().getProcessorExchangeFactory().newProcessorExchangeFactory((Processor)this);
        this.cacheSize = cacheSize;
        this.errorHandlers = cacheSize >= 0 ? (ConcurrentMap)LRUCacheFactory.newLRUCache((int)cacheSize) : null;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    public String getTraceLabel() {
        return "multicast";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    protected void doBuild() throws Exception {
        if (this.processorExchangeFactory != null) {
            this.processorExchangeFactory.setId(this.id);
            this.processorExchangeFactory.setRouteId(this.routeId);
        }
        ServiceHelper.buildService((Object)this.processorExchangeFactory);
    }

    protected void doInit() throws Exception {
        if (this.route != null) {
            DefaultExchange exchange = new DefaultExchange(this.getCamelContext());
            for (Processor processor : this.getProcessors()) {
                this.wrapInErrorHandler(this.route, (Exchange)exchange, processor);
            }
        }
        ServiceHelper.initService((Object)this.processorExchangeFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.synchronous) {
            try {
                this.awaitManager.process((AsyncProcessor)new AsyncProcessorSupport(){

                    public boolean process(Exchange exchange, AsyncCallback callback) {
                        return MulticastProcessor.this.doProcess(exchange, callback);
                    }
                }, exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            finally {
                callback.done(true);
            }
            return true;
        }
        return this.doProcess(exchange, callback);
    }

    protected boolean doProcess(Exchange exchange, AsyncCallback callback) {
        MulticastTask state;
        Iterable<ProcessorExchangePair> pairs;
        int size = 0;
        try {
            pairs = this.createProcessorExchangePairs(exchange);
            if (pairs instanceof Collection) {
                pairs = ((Collection)pairs).stream().filter(Objects::nonNull).toList();
                size = ((Collection)pairs).size();
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            this.doDone(exchange, null, null, callback, true, false);
            return true;
        }
        MulticastTask multicastTask = state = !this.isParallelProcessing() && exchange.isTransacted() ? new MulticastTransactedTask(exchange, pairs, callback, size) : new MulticastReactiveTask(exchange, pairs, callback, size);
        if (this.isParallelProcessing()) {
            try {
                this.executorService.submit(() -> this.reactiveExecutor.scheduleSync((Runnable)state));
            }
            catch (RejectedExecutionException e) {
                state.reject();
            }
        } else if (exchange.isTransacted()) {
            this.reactiveExecutor.scheduleQueue((Runnable)state);
        } else {
            this.reactiveExecutor.scheduleMain((Runnable)state);
        }
        return false;
    }

    protected void schedule(Runnable runnable) {
        this.schedule(runnable, false);
    }

    protected void schedule(Runnable runnable, boolean sync) {
        if (this.isParallelProcessing()) {
            Runnable task = this.prepareParallelTask(runnable);
            try {
                this.executorService.submit(() -> this.reactiveExecutor.scheduleSync(task));
            }
            catch (RejectedExecutionException e) {
                if (runnable instanceof Rejectable) {
                    Rejectable rej = (Rejectable)runnable;
                    rej.reject();
                }
            }
        } else if (sync) {
            this.reactiveExecutor.scheduleSync(runnable);
        } else {
            this.reactiveExecutor.schedule(runnable);
        }
    }

    private Runnable prepareParallelTask(Runnable runnable) {
        Runnable answer = runnable;
        if (this.camelContext.isUseMDCLogging().booleanValue()) {
            String pattern = this.camelContext.getMDCLoggingKeysPattern();
            Map mdc = MDC.getCopyOfContextMap();
            if (mdc != null && !mdc.isEmpty()) {
                answer = () -> {
                    try {
                        if (pattern == null || "*".equals(pattern)) {
                            mdc.forEach(MDC::put);
                        } else {
                            String[] patterns = pattern.split(",");
                            mdc.forEach((k, v) -> {
                                if (PatternHelper.matchPatterns((String)k, (String[])patterns)) {
                                    MDC.put((String)k, (String)v);
                                }
                            });
                        }
                    }
                    finally {
                        runnable.run();
                    }
                };
            }
        }
        return answer;
    }

    protected ScheduledFuture<?> schedule(Executor executor, Runnable runnable, long delay, TimeUnit unit) {
        if (executor instanceof ScheduledExecutorService) {
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)executor;
            return scheduledExecutorService.schedule(runnable, delay, unit);
        }
        executor.execute(() -> {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            runnable.run();
        });
        return null;
    }

    protected StopWatch beforeSend(ProcessorExchangePair pair) {
        boolean sending;
        Exchange e = pair.getExchange();
        Producer p = pair.getProducer();
        StopWatch watch = p != null ? ((sending = EventHelper.notifyExchangeSending((CamelContext)e.getContext(), (Exchange)e, (Endpoint)p.getEndpoint())) ? new StopWatch() : null) : null;
        pair.begin();
        return watch;
    }

    protected void afterSend(ProcessorExchangePair pair, StopWatch watch) {
        pair.done();
        Producer producer = pair.getProducer();
        if (producer != null && watch != null) {
            long timeTaken = watch.taken();
            Exchange e = pair.getExchange();
            Endpoint endpoint = producer.getEndpoint();
            EventHelper.notifyExchangeSent((CamelContext)e.getContext(), (Exchange)e, (Endpoint)endpoint, (long)timeTaken);
        }
    }

    protected void doDone(Exchange original, Exchange subExchange, Iterable<ProcessorExchangePair> pairs, AsyncCallback callback, boolean doneSync, boolean forceExhaust) {
        boolean exhaust;
        AggregationStrategy strategy = this.getAggregationStrategy(subExchange);
        if (strategy != null) {
            strategy.onCompletion(subExchange, original);
        }
        this.removeAggregationStrategyFromExchange(original);
        boolean stoppedOnException = false;
        boolean exception = false;
        boolean bl = exhaust = forceExhaust || subExchange != null && (subExchange.getException() != null || subExchange.getExchangeExtension().isRedeliveryExhausted());
        if (original.getException() != null || subExchange != null && subExchange.getException() != null) {
            stoppedOnException = this.isStopOnException();
            exception = true;
        }
        if (subExchange != null) {
            if (stoppedOnException) {
                original.setException((Throwable)subExchange.getException());
            } else {
                Iterator<ProcessorExchangePair> correlationId = original.removeProperty(ExchangePropertyKey.CORRELATION_ID);
                ExchangeHelper.copyResults((Exchange)original, (Exchange)subExchange);
                if (correlationId != null) {
                    original.setProperty(ExchangePropertyKey.CORRELATION_ID, correlationId);
                }
            }
        }
        if (this.processorExchangeFactory != null && pairs != null) {
            try {
                for (ProcessorExchangePair pair : pairs) {
                    this.processorExchangeFactory.release(pair.getExchange());
                }
            }
            catch (Exception e) {
                LOG.warn("Error releasing exchange due to {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
            }
        }
        if (pairs instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)pairs);
            IOHelper.close((Closeable)closeable, (String)"pairs", (Logger)LOG);
        }
        if (exception) {
            original.getExchangeExtension().setRedeliveryExhausted(exhaust);
        }
        this.reactiveExecutor.schedule((Runnable)callback);
    }

    protected void doAggregate(AtomicReference<Exchange> result, Exchange exchange, Exchange inputExchange) {
        if (this.parallelAggregate) {
            this.doAggregateInternal(this.getAggregationStrategy(exchange), result, exchange, inputExchange);
        } else {
            this.doAggregateSync(this.getAggregationStrategy(exchange), result, exchange, inputExchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAggregateSync(AggregationStrategy strategy, AtomicReference<Exchange> result, Exchange exchange, Exchange inputExchange) {
        this.lock.lock();
        try {
            this.doAggregateInternal(strategy, result, exchange, inputExchange);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doAggregateInternal(AggregationStrategy strategy, AtomicReference<Exchange> result, Exchange exchange, Exchange inputExchange) {
        if (strategy != null) {
            Exchange oldExchange = result.get();
            ExchangeHelper.prepareAggregation((Exchange)oldExchange, (Exchange)exchange);
            result.set(strategy.aggregate(oldExchange, exchange, inputExchange));
        }
    }

    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs, boolean hasNext) {
        exchange.setProperty(ExchangePropertyKey.MULTICAST_INDEX, (Object)index);
        if (hasNext) {
            exchange.setProperty(ExchangePropertyKey.MULTICAST_COMPLETE, (Object)Boolean.FALSE);
        } else {
            exchange.setProperty(ExchangePropertyKey.MULTICAST_COMPLETE, (Object)Boolean.TRUE);
        }
    }

    protected Integer getExchangeIndex(Exchange exchange) {
        return (Integer)exchange.getProperty(ExchangePropertyKey.MULTICAST_INDEX, Integer.class);
    }

    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        Iterator<Processor> iterator;
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(this.processors.size());
        ConcurrentHashMap txData = null;
        StreamCache streamCache = null;
        if (this.isParallelProcessing() && (iterator = exchange.getIn().getBody()) instanceof StreamCache) {
            StreamCache streamCacheBody;
            streamCache = streamCacheBody = (StreamCache)iterator;
        }
        int index = 0;
        for (Processor processor : this.processors) {
            StreamCache copiedStreamCache;
            Exchange copy = this.processorExchangeFactory.createCorrelatedCopy(exchange, false);
            copy.getExchangeExtension().setTransacted(exchange.isTransacted());
            if (exchange.isTransacted() && copy.getProperty("CamelTransactionContextData") == null) {
                if (txData == null) {
                    txData = new ConcurrentHashMap();
                }
                copy.setProperty("CamelTransactionContextData", txData);
            }
            if (streamCache != null && index > 0 && (copiedStreamCache = streamCache.copy(copy)) != null) {
                copy.getIn().setBody((Object)copiedStreamCache);
            }
            if (copy.getProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK) == null) {
                copy.setProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK, (Object)exchange.getUnitOfWork());
            }
            if (this.isShareUnitOfWork()) {
                this.prepareSharedUnitOfWork(copy, exchange);
            }
            Route route = ExchangeHelper.getRoute((Exchange)exchange);
            result.add(this.createProcessorExchangePair(index++, processor, copy, route));
        }
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        return result;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Processor processor, Exchange exchange, Route route) {
        Processor prepared = processor;
        MulticastProcessor.setToEndpoint(exchange, prepared);
        prepared = this.wrapInErrorHandler(route, exchange, prepared);
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
        }
        return new DefaultProcessorExchangePair(index, processor, prepared, exchange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Processor wrapInErrorHandler(Route route, Exchange exchange, Processor processor) {
        Processor answer;
        Processor key = processor;
        if (route != this.route && this.route != null) {
            throw new UnsupportedOperationException("Is this really correct ?");
        }
        Boolean tryBlock = (Boolean)exchange.getProperty(ExchangePropertyKey.TRY_ROUTE_BLOCK);
        if (route == null) return this.createUnitOfWorkProcessor(route, processor, exchange);
        if (tryBlock != null) {
            if (tryBlock != false) return this.createUnitOfWorkProcessor(route, processor, exchange);
        }
        Processor processor2 = answer = this.errorHandlers != null ? (Processor)this.errorHandlers.get(key) : null;
        if (answer != null) {
            LOG.trace("Using existing error handler for: {}", (Object)key);
            return answer;
        }
        LOG.trace("Creating error handler for: {}", (Object)key);
        try {
            processor = this.wrapInErrorHandler(route, key);
            answer = this.createUnitOfWorkProcessor(route, processor, exchange);
            boolean child = exchange.getProperty(ExchangePropertyKey.PARENT_UNIT_OF_WORK, UnitOfWork.class) != null;
            ServiceHelper.startService((Object)answer);
            if (child) return answer;
            if (this.errorHandlers == null) return answer;
            this.errorHandlers.putIfAbsent(key, answer);
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    private Processor wrapInErrorHandler(Route route, Processor processor) throws Exception {
        Processor processor2 = this.errorHandler;
        if (processor2 instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport errorHandlerSupport = (ErrorHandlerSupport)processor2;
            return errorHandlerSupport.clone(processor);
        }
        return this.camelContext.getCamelContextExtension().createErrorHandler(route, processor);
    }

    protected Processor createUnitOfWorkProcessor(Route route, Processor processor, Exchange exchange) {
        UnitOfWork parent = (UnitOfWork)exchange.getProperty(ExchangePropertyKey.PARENT_UNIT_OF_WORK, UnitOfWork.class);
        if (parent != null) {
            return this.internalProcessorFactory.addChildUnitOfWorkProcessorAdvice(this.camelContext, processor, route, parent);
        }
        return this.internalProcessorFactory.addUnitOfWorkProcessorAdvice(this.camelContext, processor, route);
    }

    protected void prepareSharedUnitOfWork(Exchange childExchange, Exchange parentExchange) {
        childExchange.setProperty(ExchangePropertyKey.PARENT_UNIT_OF_WORK, (Object)parentExchange.getUnitOfWork());
    }

    protected void doStart() throws Exception {
        if (this.isParallelProcessing() && this.executorService == null) {
            throw new IllegalArgumentException("ParallelProcessing is enabled but ExecutorService has not been set");
        }
        if (this.timeout > 0L && this.aggregateExecutorService == null) {
            String name = ((Object)((Object)this)).getClass().getSimpleName() + "-AggregateTask";
            this.aggregateExecutorService = this.createAggregateExecutorService(name);
            this.shutdownAggregateExecutorService = true;
        }
        CamelContextAware.trySetCamelContext((Object)this.aggregationStrategy, (CamelContext)this.camelContext);
        ServiceHelper.startService((Object[])new Object[]{this.aggregationStrategy, this.processors, this.processorExchangeFactory});
    }

    protected ExecutorService createAggregateExecutorService(String name) {
        this.lock.lock();
        try {
            ScheduledExecutorService scheduledExecutorService = this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, name, 0);
            return scheduledExecutorService;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.processors, this.errorHandlers, this.aggregationStrategy, this.processorExchangeFactory});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.processors, this.errorHandlers, this.aggregationStrategy, this.processorExchangeFactory});
        if (this.errorHandlers != null) {
            this.errorHandlers.clear();
        }
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
        if (this.shutdownAggregateExecutorService && this.aggregateExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.aggregateExecutorService);
        }
    }

    protected static void setToEndpoint(Exchange exchange, Processor processor) {
        if (processor instanceof Producer) {
            Producer producer = (Producer)processor;
            exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)producer.getEndpoint().getEndpointUri());
        }
    }

    protected AggregationStrategy getAggregationStrategy(Exchange exchange) {
        Map property;
        Map map;
        AggregationStrategy answer = null;
        if (exchange != null && (map = CastUtils.cast((Map)(property = (Map)exchange.getProperty(ExchangePropertyKey.AGGREGATION_STRATEGY, Map.class)))) != null) {
            answer = (AggregationStrategy)map.get((Object)this);
        }
        if (answer == null) {
            answer = this.getAggregationStrategy();
        }
        return answer;
    }

    protected void setAggregationStrategyOnExchange(Exchange exchange, AggregationStrategy aggregationStrategy) {
        Map property = (Map)exchange.getProperty(ExchangePropertyKey.AGGREGATION_STRATEGY, Map.class);
        ConcurrentHashMap<MulticastProcessor, Object> map = CastUtils.cast((Map)property);
        map = map == null ? new ConcurrentHashMap<MulticastProcessor, AggregationStrategy>() : new ConcurrentHashMap(map);
        map.put(this, aggregationStrategy);
        exchange.setProperty(ExchangePropertyKey.AGGREGATION_STRATEGY, map);
    }

    protected void removeAggregationStrategyFromExchange(Exchange exchange) {
        Map property = (Map)exchange.getProperty(ExchangePropertyKey.AGGREGATION_STRATEGY, Map.class);
        Map map = CastUtils.cast((Map)property);
        if (map == null) {
            return;
        }
        map.remove((Object)this);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    @Deprecated(since="4.7.0")
    public boolean isParallelAggregate() {
        return this.parallelAggregate;
    }

    public boolean isShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public ExecutorService getAggregateExecutorService() {
        return this.aggregateExecutorService;
    }

    public void setAggregateExecutorService(ExecutorService aggregateExecutorService) {
        this.aggregateExecutorService = aggregateExecutorService;
        this.shutdownAggregateExecutorService = false;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<Processor>(this.processors);
    }

    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }

    private final class Scheduler
    implements Executor {
        private Scheduler() {
        }

        @Override
        public void execute(Runnable command) {
            MulticastProcessor.this.schedule(command, false);
        }
    }

    private final class SyncScheduler
    implements Executor {
        private SyncScheduler() {
        }

        @Override
        public void execute(Runnable command) {
            MulticastProcessor.this.schedule(command, true);
        }
    }

    protected class MulticastTransactedTask
    extends MulticastTask {
        public MulticastTransactedTask(Exchange original, Iterable<ProcessorExchangePair> pairs, AsyncCallback callback, int size) {
            super(original, pairs, callback, size, true);
        }

        @Override
        public void run() {
            super.run();
            boolean next = true;
            while (next) {
                try {
                    next = this.doRun();
                }
                catch (Exception e) {
                    this.original.setException((Throwable)e);
                    this.doDone(null, false);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean doRun() throws Exception {
            if (this.done.get()) {
                return false;
            }
            if (!this.iterator.hasNext()) {
                this.doDone((Exchange)this.result.get(), true);
                return false;
            }
            ProcessorExchangePair pair = (ProcessorExchangePair)this.iterator.next();
            if (pair == null) {
                return true;
            }
            boolean hasNext = this.iterator.hasNext();
            Exchange exchange = pair.getExchange();
            int index = this.nbExchangeSent.getAndIncrement();
            MulticastProcessor.this.updateNewExchange(exchange, index, this.pairs, hasNext);
            if (!hasNext) {
                this.allSent.set(true);
            }
            StopWatch watch = MulticastProcessor.this.beforeSend(pair);
            Processor sync = pair.getProcessor();
            try {
                sync.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            finally {
                MulticastProcessor.this.afterSend(pair, watch);
            }
            String msg = null;
            if (LOG.isDebugEnabled()) {
                msg = "Multicast processing failed for number " + index;
            }
            boolean continueProcessing = PipelineHelper.continueProcessing(exchange, msg, LOG);
            if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                if (exchange.getException() != null) {
                    exchange.setException((Throwable)new CamelExchangeException("Multicast processing failed for number " + index, exchange, (Throwable)exchange.getException()));
                } else {
                    this.result.set(exchange);
                }
                this.doDone(exchange, true);
                return false;
            }
            this.completion.submit(exchangeResult -> {
                exchangeResult.accept(exchange);
                this.aggregate();
            });
            if (hasNext && MulticastProcessor.this.isParallelProcessing()) {
                MulticastProcessor.this.schedule(this);
            }
            boolean next = hasNext && !MulticastProcessor.this.isParallelProcessing();
            LOG.trace("Run next: {}", (Object)next);
            return next;
        }
    }

    protected class MulticastReactiveTask
    extends MulticastTask {
        public MulticastReactiveTask(Exchange original, Iterable<ProcessorExchangePair> pairs, AsyncCallback callback, int size) {
            super(original, pairs, callback, size, false);
        }

        @Override
        public void run() {
            super.run();
            try {
                if (this.done.get()) {
                    return;
                }
                ProcessorExchangePair pair = this.getNextProcessorExchangePair();
                if (pair == null) {
                    this.doDone((Exchange)this.result.get(), true);
                    return;
                }
                boolean hasNext = this.iterator.hasNext();
                Exchange exchange = pair.getExchange();
                int index = this.nbExchangeSent.getAndIncrement();
                MulticastProcessor.this.updateNewExchange(exchange, index, this.pairs, hasNext);
                if (!hasNext) {
                    this.allSent.set(true);
                }
                this.completion.submit(exchangeResult -> {
                    StopWatch watch = MulticastProcessor.this.beforeSend(pair);
                    AsyncProcessor async = AsyncProcessorConverterHelper.convert((Processor)pair.getProcessor());
                    async.process(exchange, doneSync -> {
                        MulticastProcessor.this.afterSend(pair, watch);
                        String msg = null;
                        if (LOG.isDebugEnabled()) {
                            msg = "Multicast processing failed for number " + index;
                        }
                        boolean continueProcessing = PipelineHelper.continueProcessing(exchange, msg, LOG);
                        if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                            if (exchange.getException() != null) {
                                exchange.setException((Throwable)new CamelExchangeException("Multicast processing failed for number " + index, exchange, (Throwable)exchange.getException()));
                            } else {
                                this.result.set(exchange);
                            }
                            this.doDone(exchange, true);
                            return;
                        }
                        exchangeResult.accept(exchange);
                        this.aggregate();
                        if (hasNext && !MulticastProcessor.this.isParallelProcessing()) {
                            MulticastProcessor.this.schedule(this);
                        }
                    });
                });
                if (hasNext && MulticastProcessor.this.isParallelProcessing()) {
                    MulticastProcessor.this.schedule(this);
                }
            }
            catch (Exception e) {
                this.original.setException((Throwable)e);
                this.doDone(null, false);
            }
        }

        private ProcessorExchangePair getNextProcessorExchangePair() {
            ProcessorExchangePair tpair = null;
            while (tpair == null && this.iterator.hasNext()) {
                tpair = (ProcessorExchangePair)this.iterator.next();
            }
            return tpair;
        }
    }

    protected abstract class MulticastTask
    implements Runnable,
    Rejectable {
        final Exchange original;
        final Iterable<ProcessorExchangePair> pairs;
        final AsyncCallback callback;
        final Iterator<ProcessorExchangePair> iterator;
        final ReentrantLock lock = new ReentrantLock();
        final AsyncCompletionService<Exchange> completion;
        final AtomicReference<Exchange> result = new AtomicReference();
        final AtomicInteger nbExchangeSent = new AtomicInteger();
        final AtomicInteger nbAggregated = new AtomicInteger();
        final AtomicBoolean allSent = new AtomicBoolean();
        final AtomicBoolean done = new AtomicBoolean();
        final Map<String, String> mdc;
        final ScheduledFuture<?> timeoutTask;

        MulticastTask(Exchange original, Iterable<ProcessorExchangePair> pairs, AsyncCallback callback, int capacity, boolean sync) {
            this.original = original;
            this.pairs = pairs;
            this.callback = callback;
            this.iterator = pairs.iterator();
            this.timeoutTask = MulticastProcessor.this.timeout > 0L ? MulticastProcessor.this.schedule(MulticastProcessor.this.aggregateExecutorService, this::timeout, MulticastProcessor.this.timeout, TimeUnit.MILLISECONDS) : null;
            this.mdc = MulticastProcessor.this.isParallelProcessing() && original.getContext().isUseMDCLogging() != false ? MDC.getCopyOfContextMap() : null;
            this.completion = capacity > 0 ? new AsyncCompletionService(sync ? MulticastProcessor.this.syncScheduler : MulticastProcessor.this.scheduler, !MulticastProcessor.this.isStreaming(), this.lock, capacity) : new AsyncCompletionService(sync ? MulticastProcessor.this.syncScheduler : MulticastProcessor.this.scheduler, !MulticastProcessor.this.isStreaming(), this.lock);
        }

        public String toString() {
            return "MulticastTask";
        }

        @Override
        public void run() {
            if (this.mdc != null) {
                this.mdc.forEach(MDC::put);
            }
        }

        protected void aggregate() {
            ReentrantLock lock = this.lock;
            if (lock.tryLock()) {
                try {
                    Exchange exchange;
                    while (!this.done.get() && (exchange = (Exchange)this.completion.poll()) != null) {
                        MulticastProcessor.this.doAggregate(this.result, exchange, this.original);
                        if (this.nbAggregated.incrementAndGet() < this.nbExchangeSent.get() || !this.allSent.get()) continue;
                        this.doDone(this.result.get(), true);
                    }
                }
                catch (Exception e) {
                    this.original.setException((Throwable)e);
                    this.doDone(null, false);
                }
                finally {
                    lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void timeout() {
            ReentrantLock lock = this.lock;
            if (lock.tryLock()) {
                try {
                    while (this.nbAggregated.get() < this.nbExchangeSent.get()) {
                        int index;
                        Exchange exchange = (Exchange)this.completion.pollUnordered();
                        int n = index = exchange != null ? MulticastProcessor.this.getExchangeIndex(exchange).intValue() : this.nbExchangeSent.get();
                        while (this.nbAggregated.get() < index) {
                            int idx = this.nbAggregated.getAndIncrement();
                            AggregationStrategy strategy = MulticastProcessor.this.getAggregationStrategy(null);
                            if (strategy == null) continue;
                            strategy.timeout(this.result.get() != null ? this.result.get() : this.original, idx, this.nbExchangeSent.get(), MulticastProcessor.this.timeout);
                        }
                        if (exchange == null) continue;
                        MulticastProcessor.this.doAggregate(this.result, exchange, this.original);
                        this.nbAggregated.incrementAndGet();
                    }
                    this.doTimeoutDone(this.result.get(), true);
                }
                catch (Exception e) {
                    this.original.setException((Throwable)e);
                    this.doTimeoutDone(null, false);
                }
                finally {
                    lock.unlock();
                }
            }
        }

        protected void doTimeoutDone(Exchange exchange, boolean forceExhaust) {
            if (this.done.compareAndSet(false, true)) {
                MulticastProcessor.this.doDone(this.original, exchange, this.pairs, this.callback, false, forceExhaust);
            }
        }

        protected void doDone(Exchange exchange, boolean forceExhaust) {
            if (this.done.compareAndSet(false, true)) {
                if (this.timeoutTask != null) {
                    try {
                        this.timeoutTask.cancel(true);
                    }
                    catch (Exception e) {
                        LOG.debug("Cancel timeout task caused an exception. This exception is ignored.", (Throwable)e);
                    }
                }
                MulticastProcessor.this.doDone(this.original, exchange, this.pairs, this.callback, false, forceExhaust);
            }
        }

        public void reject() {
            this.original.setException((Throwable)new RejectedExecutionException("Task rejected executing from ExecutorService"));
            this.doDone(null, false);
        }
    }

    static final class DefaultProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Processor processor;
        private final Processor prepared;
        private final Exchange exchange;

        private DefaultProcessorExchangePair(int index, Processor processor, Processor prepared, Exchange exchange) {
            this.index = index;
            this.processor = processor;
            this.prepared = prepared;
            this.exchange = exchange;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Exchange getExchange() {
            return this.exchange;
        }

        @Override
        public Producer getProducer() {
            Processor processor = this.processor;
            if (processor instanceof Producer) {
                Producer producer = (Producer)processor;
                return producer;
            }
            return null;
        }

        @Override
        public Processor getProcessor() {
            return this.prepared;
        }

        @Override
        public void begin() {
        }

        @Override
        public void done() {
        }
    }
}

