/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedRoute;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InputTypeDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.OutputTypeDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RoutePolicy;

@Metadata(label="configuration")
@XmlRootElement(name="route")
@XmlType(propOrder={"input", "inputType", "outputType", "outputs", "routeProperties"})
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class RouteDefinition
extends OutputDefinition<RouteDefinition>
implements NamedRoute {
    private final AtomicBoolean prepared = new AtomicBoolean(false);
    private FromDefinition input;
    private String group;
    private String streamCache;
    private String trace;
    private String messageHistory;
    private String logMask;
    private String delayer;
    private String autoStartup;
    private Integer startupOrder;
    private List<RoutePolicy> routePolicies;
    private String routePolicyRef;
    private String shutdownRoute;
    private String shutdownRunningTask;
    private String errorHandlerRef;
    private ErrorHandlerFactory errorHandlerFactory;
    private boolean contextScopedErrorHandler = true;
    private Boolean rest;
    private RestDefinition restDefinition;
    private RestBindingDefinition restBindingDefinition;
    private InputTypeDefinition inputType;
    private OutputTypeDefinition outputType;
    private List<PropertyDefinition> routeProperties;

    public RouteDefinition() {
    }

    public RouteDefinition(@AsEndpointUri String uri) {
        this.from(uri);
    }

    public RouteDefinition(Endpoint endpoint) {
        this.from(endpoint);
    }

    public void fromRest(@AsEndpointUri String uri) {
        this.from(uri);
        this.rest = true;
    }

    public boolean isPrepared() {
        return this.prepared.get();
    }

    public void markPrepared() {
        this.prepared.set(true);
    }

    public void markUnprepared() {
        this.prepared.set(false);
    }

    @Override
    public String toString() {
        if (this.getId() != null) {
            return "Route(" + this.getId() + ")[" + (this.input != null ? this.input : "") + " -> " + this.outputs + "]";
        }
        return "Route[" + this.input + " -> " + this.outputs + "]";
    }

    @Override
    public String getShortName() {
        return "route";
    }

    @Override
    public String getLabel() {
        return "Route[" + this.input.getLabel() + "]";
    }

    public String getRouteId() {
        return this.getId();
    }

    public String getEndpointUrl() {
        return this.input != null ? this.input.getEndpointUri() : null;
    }

    public RouteDefinition from(@AsEndpointUri String uri) {
        this.setInput(new FromDefinition(uri));
        return this;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.setInput(new FromDefinition(endpoint));
        return this;
    }

    public RouteDefinition from(EndpointConsumerBuilder endpoint) {
        this.setInput(new FromDefinition(endpoint));
        return this;
    }

    public RouteDefinition group(String name) {
        this.setGroup(name);
        return this;
    }

    @Override
    public RouteDefinition routeGroup(String group) {
        this.setGroup(group);
        return this;
    }

    @Override
    public RouteDefinition routeId(String id) {
        if (this.hasCustomIdAssigned()) {
            throw new IllegalArgumentException("You can only set routeId one time per route.");
        }
        this.setId(id);
        return this;
    }

    @Override
    public RouteDefinition routeDescription(String description) {
        DescriptionDefinition desc = new DescriptionDefinition();
        desc.setText(description);
        this.setDescription(desc);
        return this;
    }

    public RouteDefinition noStreamCaching() {
        this.setStreamCache("false");
        return this;
    }

    public RouteDefinition streamCaching() {
        this.setStreamCache("true");
        return this;
    }

    public RouteDefinition streamCaching(String streamCache) {
        this.setStreamCache(streamCache);
        return this;
    }

    public RouteDefinition noTracing() {
        this.setTrace("false");
        return this;
    }

    public RouteDefinition tracing() {
        this.setTrace("true");
        return this;
    }

    public RouteDefinition tracing(String tracing) {
        this.setTrace(tracing);
        return this;
    }

    public RouteDefinition messageHistory() {
        this.setMessageHistory("true");
        return this;
    }

    public RouteDefinition messageHistory(String messageHistory) {
        this.setMessageHistory(messageHistory);
        return this;
    }

    public RouteDefinition logMask() {
        this.setLogMask("true");
        return this;
    }

    public RouteDefinition logMask(String logMask) {
        this.setLogMask(logMask);
        return this;
    }

    public RouteDefinition noMessageHistory() {
        this.setMessageHistory("false");
        return this;
    }

    public RouteDefinition noDelayer() {
        this.setDelayer("0");
        return this;
    }

    public RouteDefinition delayer(long delay) {
        this.setDelayer("" + delay);
        return this;
    }

    public RouteDefinition errorHandler(ErrorHandlerFactory errorHandlerBuilder) {
        this.setErrorHandlerFactory(errorHandlerBuilder);
        this.contextScopedErrorHandler = false;
        return this;
    }

    public RouteDefinition noAutoStartup() {
        this.setAutoStartup("false");
        return this;
    }

    public RouteDefinition autoStartup(String autoStartup) {
        this.setAutoStartup(autoStartup);
        return this;
    }

    public RouteDefinition autoStartup(boolean autoStartup) {
        this.setAutoStartup(Boolean.toString(autoStartup));
        return this;
    }

    @Override
    public RouteDefinition startupOrder(int order) {
        this.setStartupOrder(order);
        return this;
    }

    public RouteDefinition routePolicy(RoutePolicy ... policies) {
        if (this.routePolicies == null) {
            this.routePolicies = new ArrayList<RoutePolicy>();
        }
        this.routePolicies.addAll(Arrays.asList(policies));
        return this;
    }

    public RouteDefinition routePolicy(Supplier<RoutePolicy> policy) {
        return this.routePolicy(policy.get());
    }

    public RouteDefinition routePolicyRef(String routePolicyRef) {
        this.setRoutePolicyRef(routePolicyRef);
        return this;
    }

    public RouteDefinition shutdownRoute(ShutdownRoute shutdownRoute) {
        return this.shutdownRoute(shutdownRoute.name());
    }

    public RouteDefinition shutdownRoute(String shutdownRoute) {
        this.setShutdownRoute(shutdownRoute);
        return this;
    }

    public RouteDefinition shutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        return this.shutdownRunningTask(shutdownRunningTask.name());
    }

    public RouteDefinition shutdownRunningTask(String shutdownRunningTask) {
        this.setShutdownRunningTask(shutdownRunningTask);
        return this;
    }

    public RouteDefinition inputType(String urn) {
        this.inputType = new InputTypeDefinition().urn(urn).validate(false);
        return this;
    }

    public RouteDefinition inputTypeWithValidate(String urn) {
        this.inputType = new InputTypeDefinition().urn(urn).validate(true);
        return this;
    }

    public RouteDefinition inputType(Class clazz) {
        this.inputType = new InputTypeDefinition().javaClass(clazz).validate(false);
        return this;
    }

    public RouteDefinition inputTypeWithValidate(Class clazz) {
        this.inputType = new InputTypeDefinition().javaClass(clazz).validate(true);
        return this;
    }

    public RouteDefinition outputType(String urn) {
        this.outputType = new OutputTypeDefinition().urn(urn).validate(false);
        return this;
    }

    public RouteDefinition outputTypeWithValidate(String urn) {
        this.outputType = new OutputTypeDefinition().urn(urn).validate(true);
        return this;
    }

    public RouteDefinition outputType(Class clazz) {
        this.outputType = new OutputTypeDefinition().javaClass(clazz).validate(false);
        return this;
    }

    public RouteDefinition outputTypeWithValidate(Class clazz) {
        this.outputType = new OutputTypeDefinition().javaClass(clazz).validate(true);
        return this;
    }

    public RouteDefinition routeProperty(String key, String value) {
        if (this.routeProperties == null) {
            this.routeProperties = new ArrayList<PropertyDefinition>();
        }
        PropertyDefinition prop = new PropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.routeProperties.add(prop);
        return this;
    }

    public FromDefinition getInput() {
        return this.input;
    }

    @XmlElementRef(required=false)
    public void setInput(FromDefinition input) {
        this.input = input;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    public String getGroup() {
        return this.group;
    }

    @XmlAttribute
    public void setGroup(String group) {
        this.group = group;
    }

    public String getStreamCache() {
        return this.streamCache;
    }

    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    public void setStreamCache(String streamCache) {
        this.streamCache = streamCache;
    }

    public String getTrace() {
        return this.trace;
    }

    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    public void setTrace(String trace) {
        this.trace = trace;
    }

    public String getMessageHistory() {
        return this.messageHistory;
    }

    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    public void setMessageHistory(String messageHistory) {
        this.messageHistory = messageHistory;
    }

    public String getLogMask() {
        return this.logMask;
    }

    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    public void setLogMask(String logMask) {
        this.logMask = logMask;
    }

    public String getDelayer() {
        return this.delayer;
    }

    @XmlAttribute
    @Metadata(javaType="java.lang.Long")
    public void setDelayer(String delayer) {
        this.delayer = delayer;
    }

    public String getAutoStartup() {
        return this.autoStartup;
    }

    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    public void setAutoStartup(String autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Integer getStartupOrder() {
        return this.startupOrder;
    }

    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    public void setStartupOrder(Integer startupOrder) {
        this.startupOrder = startupOrder;
    }

    @XmlAttribute
    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
        this.setErrorHandlerFactory(new ErrorHandlerBuilderRef(errorHandlerRef));
    }

    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    @XmlTransient
    public void setErrorHandlerFactoryIfNull(ErrorHandlerFactory errorHandlerFactory) {
        if (this.errorHandlerFactory == null) {
            this.setErrorHandlerFactory(errorHandlerFactory);
        }
    }

    @XmlAttribute
    public void setRoutePolicyRef(String routePolicyRef) {
        this.routePolicyRef = routePolicyRef;
    }

    public String getRoutePolicyRef() {
        return this.routePolicyRef;
    }

    public List<RoutePolicy> getRoutePolicies() {
        return this.routePolicies;
    }

    @XmlTransient
    public void setRoutePolicies(List<RoutePolicy> routePolicies) {
        this.routePolicies = routePolicies;
    }

    public String getShutdownRoute() {
        return this.shutdownRoute;
    }

    @XmlAttribute
    @Metadata(javaType="org.apache.camel.ShutdownRoute", defaultValue="Default", enums="Default,Defer")
    public void setShutdownRoute(String shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public String getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    @XmlAttribute
    @Metadata(javaType="org.apache.camel.ShutdownRunningTask", defaultValue="CompleteCurrentTaskOnly", enums="CompleteCurrentTaskOnly,CompleteAllTasks")
    public void setShutdownRunningTask(String shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    private ErrorHandlerFactory createErrorHandlerBuilder() {
        if (this.errorHandlerRef != null) {
            return new ErrorHandlerBuilderRef(this.errorHandlerRef);
        }
        return new ErrorHandlerBuilderRef("CamelDefaultErrorHandlerBuilder");
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        if (this.errorHandlerFactory == null) {
            this.errorHandlerFactory = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerFactory;
    }

    @XmlTransient
    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    @XmlAttribute
    public Boolean isRest() {
        return this.rest;
    }

    public RestDefinition getRestDefinition() {
        return this.restDefinition;
    }

    @XmlTransient
    public void setRestDefinition(RestDefinition restDefinition) {
        this.restDefinition = restDefinition;
    }

    public RestBindingDefinition getRestBindingDefinition() {
        return this.restBindingDefinition;
    }

    @XmlTransient
    public void setRestBindingDefinition(RestBindingDefinition restBindingDefinition) {
        this.restBindingDefinition = restBindingDefinition;
    }

    public boolean isContextScopedErrorHandler() {
        return this.contextScopedErrorHandler;
    }

    @XmlElementRef(required=false)
    public void setInputType(InputTypeDefinition inputType) {
        this.inputType = inputType;
    }

    public InputTypeDefinition getInputType() {
        return this.inputType;
    }

    @XmlElementRef(required=false)
    public void setOutputType(OutputTypeDefinition outputType) {
        this.outputType = outputType;
    }

    public OutputTypeDefinition getOutputType() {
        return this.outputType;
    }

    public List<PropertyDefinition> getRouteProperties() {
        return this.routeProperties;
    }

    @XmlElement(name="routeProperty")
    @Metadata(label="advanced")
    public void setRouteProperties(List<PropertyDefinition> routeProperties) {
        this.routeProperties = routeProperties;
    }

    public static RouteDefinition fromUri(String uri) {
        return new RouteDefinition().from(uri);
    }

    public static RouteDefinition fromEndpoint(Endpoint endpoint) {
        return new RouteDefinition().from(endpoint);
    }
}

