/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.ftp.transformers;

import java.util.Map;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpRemoteFileTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String FIELD_KEY_CONFIG = "key";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("key", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Transforms Remote File to String");
    private static final Logger LOG = LoggerFactory.getLogger(FtpRemoteFileTransforms.class);

    public R apply(R r) {
        Object value = r.value();
        if (r.value() instanceof RemoteFile) {
            LOG.debug("Converting record from RemoteFile to text");
            RemoteFile message = (RemoteFile)value;
            LOG.debug("Received text: {}", message.getBody());
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), null, r.key(), (Schema)SchemaHelper.buildSchemaBuilderForType((Object)message.getBody()), message.getBody(), r.timestamp());
        }
        LOG.debug("Unexpected message type: {}", value == null ? "null instance" : value.getClass());
        return r;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }
}

