/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.parser.type;

import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenDataConsumer;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.parser.type.AcceptKind;
import com.worldturner.medeia.parser.type.SingleType;
import com.worldturner.medeia.reflection.ConvertTypeKt;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/worldturner/medeia/parser/type/NumberType;", "Lcom/worldturner/medeia/parser/type/SingleType;", "()V", "accepts", "Lcom/worldturner/medeia/parser/type/AcceptKind;", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "createObject", "", "location", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "write", "", "value", "", "consumer", "Lcom/worldturner/medeia/parser/JsonTokenDataConsumer;", "medeia-validator-core"})
public final class NumberType
extends SingleType {
    public static final NumberType INSTANCE;

    @Override
    @NotNull
    public AcceptKind accepts(@NotNull JsonTokenData token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        return token.getType() == JsonTokenType.VALUE_NUMBER ? AcceptKind.SINGLE : AcceptKind.NOT_ACCEPTED;
    }

    @Override
    @NotNull
    public Number createObject(@NotNull JsonTokenData token, @NotNull JsonTokenLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        BigDecimal bigDecimal = token.toDecimal();
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"token.toDecimal()");
        return bigDecimal;
    }

    @Override
    public void write(@Nullable Object value, @NotNull JsonTokenDataConsumer consumer) {
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        consumer.consume(ConvertTypeKt.convertType(value, JsonTokenType.VALUE_NUMBER));
    }

    private NumberType() {
    }

    static {
        NumberType numberType;
        INSTANCE = numberType = new NumberType();
    }
}

