/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.errorhandler.DefaultExceptionPolicyStrategy;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.ExceptionPolicyKey;
import org.apache.camel.processor.errorhandler.ExceptionPolicyStrategy;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.support.ChildServiceSupport;
import org.apache.camel.support.processor.DefaultExchangeFormatter;

public abstract class ErrorHandlerSupport
extends ChildServiceSupport
implements ErrorHandler {
    protected static final DefaultExchangeFormatter DEFAULT_EXCHANGE_FORMATTER = new DefaultExchangeFormatter();
    protected final ExceptionPolicyStrategy exceptionPolicy = DefaultExceptionPolicyStrategy.INSTANCE;
    protected Map<ExceptionPolicyKey, ExceptionPolicy> exceptionPolicies;

    public void addErrorHandler(Processor errorHandler) {
        this.addChildService(errorHandler);
    }

    public void addExceptionPolicy(ExceptionPolicyKey key, ExceptionPolicy policy) {
        if (this.exceptionPolicies == null) {
            this.exceptionPolicies = new LinkedHashMap<ExceptionPolicyKey, ExceptionPolicy>();
        }
        this.exceptionPolicies.put(key, policy);
    }

    protected ExceptionPolicy getExceptionPolicy(Exchange exchange, Throwable exception) {
        if (this.exceptionPolicy == null) {
            throw new IllegalStateException("The exception policy has not been set");
        }
        if (this.exceptionPolicies == null) {
            return null;
        }
        ExceptionPolicyKey key = this.exceptionPolicy.getExceptionPolicy(this.exceptionPolicies.keySet(), exchange, exception);
        return key != null ? this.exceptionPolicies.get(key) : null;
    }

    public abstract boolean supportTransacted();

    public boolean isDeadLetterChannel() {
        return false;
    }

    public abstract Processor getOutput();

    public abstract ErrorHandler clone(Processor var1);

    static {
        DEFAULT_EXCHANGE_FORMATTER.setShowExchangeId(true);
        DEFAULT_EXCHANGE_FORMATTER.setMultiline(true);
        DEFAULT_EXCHANGE_FORMATTER.setShowHeaders(true);
        DEFAULT_EXCHANGE_FORMATTER.setStyle(DefaultExchangeFormatter.OutputStyle.Fixed);
    }
}

