/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFName;

public class PDFEncoding
extends PDFDictionary {
    public static final String STANDARD_ENCODING = "StandardEncoding";
    public static final String MAC_ROMAN_ENCODING = "MacRomanEncoding";
    public static final String MAC_EXPERT_ENCODING = "MacExpertEncoding";
    public static final String WIN_ANSI_ENCODING = "WinAnsiEncoding";
    public static final String PDF_DOC_ENCODING = "PDFDocEncoding";
    private static final Set PREDEFINED_ENCODINGS;

    public PDFEncoding(String basename) {
        this.put("Type", new PDFName("Encoding"));
        if (basename != null) {
            this.put("BaseEncoding", new PDFName(basename));
        }
    }

    static Object createPDFEncoding(SingleByteEncoding encoding, String fontName) {
        CodePointMapping baseEncoding;
        if (encoding == null) {
            return null;
        }
        String encodingName = null;
        if (fontName.indexOf("Symbol") >= 0) {
            baseEncoding = CodePointMapping.getMapping("SymbolEncoding");
            encodingName = baseEncoding.getName();
        } else {
            baseEncoding = CodePointMapping.getMapping(STANDARD_ENCODING);
        }
        PDFEncoding pdfEncoding = new PDFEncoding(encodingName);
        DifferencesBuilder builder = pdfEncoding.createDifferencesBuilder();
        PDFArray differences = builder.buildDifferencesArray(baseEncoding, encoding);
        if (differences.length() > 0) {
            pdfEncoding.setDifferences(differences);
            return pdfEncoding;
        }
        return encodingName;
    }

    public static boolean isPredefinedEncoding(String name) {
        return PREDEFINED_ENCODINGS.contains(name);
    }

    static boolean hasStandardEncoding(String encodingName) {
        return encodingName.equals(STANDARD_ENCODING);
    }

    public DifferencesBuilder createDifferencesBuilder() {
        return new DifferencesBuilder();
    }

    public void setDifferences(PDFArray differences) {
        this.put("Differences", differences);
    }

    static {
        HashSet<String> encodings = new HashSet<String>();
        encodings.add(STANDARD_ENCODING);
        encodings.add(MAC_ROMAN_ENCODING);
        encodings.add(MAC_EXPERT_ENCODING);
        encodings.add(WIN_ANSI_ENCODING);
        encodings.add(PDF_DOC_ENCODING);
        PREDEFINED_ENCODINGS = Collections.unmodifiableSet(encodings);
    }

    public class DifferencesBuilder {
        private int currentCode = -1;

        public PDFArray buildDifferencesArray(SingleByteEncoding encodingA, SingleByteEncoding encodingB) {
            PDFArray differences = new PDFArray();
            int start = -1;
            String[] baseNames = encodingA.getCharNameMap();
            String[] charNameMap = encodingB.getCharNameMap();
            int ci = charNameMap.length;
            for (int i = 0; i < ci; ++i) {
                String basec = baseNames[i];
                String c = charNameMap[i];
                if (basec.equals(c)) continue;
                if (start != i) {
                    this.addDifference(i, differences);
                    start = i;
                }
                this.addName(c, differences);
                ++start;
            }
            return differences;
        }

        private void addDifference(int code, PDFArray differences) {
            this.currentCode = code;
            differences.add((Object)code);
        }

        private void addName(String name, PDFArray differences) {
            if (this.currentCode < 0) {
                throw new IllegalStateException("addDifference(int) must be called first");
            }
            differences.add(new PDFName(name));
        }
    }
}

