/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde.avro;

import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.reflect.ReflectData;
import org.apache.kafka.common.errors.SerializationException;

public class AvroSchemaUtils {
    private static final Map<String, Schema> primitiveSchemas;

    private static Schema createPrimitiveSchema(Schema.Parser parser, String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return parser.parse(schemaString);
    }

    public static Schema parse(String schema) {
        return new Schema.Parser().parse(schema);
    }

    public static boolean isPrimitive(Schema schema) {
        return primitiveSchemas.containsValue(schema);
    }

    static Schema getReflectSchema(Object object) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        Schema schema = ReflectData.get().getSchema(clazz);
        if (schema == null) {
            throw new SerializationException("No schema for class: " + clazz.getName());
        }
        return schema;
    }

    static Schema getSchema(Object object) {
        if (object == null) {
            return primitiveSchemas.get("Null");
        }
        if (object instanceof Boolean) {
            return primitiveSchemas.get("Boolean");
        }
        if (object instanceof Integer) {
            return primitiveSchemas.get("Integer");
        }
        if (object instanceof Long) {
            return primitiveSchemas.get("Long");
        }
        if (object instanceof Float) {
            return primitiveSchemas.get("Float");
        }
        if (object instanceof Double) {
            return primitiveSchemas.get("Double");
        }
        if (object instanceof CharSequence) {
            return primitiveSchemas.get("String");
        }
        if (object instanceof byte[]) {
            return primitiveSchemas.get("Bytes");
        }
        if (object instanceof GenericContainer) {
            return ((GenericContainer)object).getSchema();
        }
        throw new IllegalArgumentException("Unsupported Avro type. Supported types are null, Boolean, Integer, Long, Float, Double, String, byte[], ReflectData and GenericContainer");
    }

    static {
        Schema.Parser parser = new Schema.Parser();
        primitiveSchemas = new HashMap<String, Schema>();
        primitiveSchemas.put("Null", AvroSchemaUtils.createPrimitiveSchema(parser, "null"));
        primitiveSchemas.put("Boolean", AvroSchemaUtils.createPrimitiveSchema(parser, "boolean"));
        primitiveSchemas.put("Integer", AvroSchemaUtils.createPrimitiveSchema(parser, "int"));
        primitiveSchemas.put("Long", AvroSchemaUtils.createPrimitiveSchema(parser, "long"));
        primitiveSchemas.put("Float", AvroSchemaUtils.createPrimitiveSchema(parser, "float"));
        primitiveSchemas.put("Double", AvroSchemaUtils.createPrimitiveSchema(parser, "double"));
        primitiveSchemas.put("String", AvroSchemaUtils.createPrimitiveSchema(parser, "string"));
        primitiveSchemas.put("Bytes", AvroSchemaUtils.createPrimitiveSchema(parser, "bytes"));
    }
}

